/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtr2qvts;

import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.utilities.Nameable;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.RegionHelper;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.QVTrelationScheduleManager;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.RelationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace.DispatchClass2TraceProperty;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace.Relation2DispatchClass;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace.Relation2MiddleType;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace.Relation2TraceClass;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace.Relation2TraceGroup;
import org.eclipse.qvtd.pivot.qvtbase.Rule;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtrelation.Relation;
import org.eclipse.qvtd.pivot.qvtrelation.utilities.QVTrelationUtil;
import org.eclipse.qvtd.pivot.qvtschedule.ClassDatum;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.RuleRegion;
import org.eclipse.qvtd.pivot.qvtschedule.Utility;
import org.eclipse.qvtd.pivot.qvtschedule.VerdictRegion;

public class RelationVerdictAnalysis
extends RegionHelper<RuleRegion> {
    protected final @NonNull RelationAnalysis relationAnalysis;
    protected final @NonNull Relation relation;

    public RelationVerdictAnalysis(@NonNull RelationAnalysis relationAnalysis, @NonNull VerdictRegion verdictRegion) {
        super(relationAnalysis.getScheduleManager(), verdictRegion);
        this.relationAnalysis = relationAnalysis;
        this.relation = relationAnalysis.getRule();
    }

    public void gatherRuleRegions(@NonNull List<@NonNull RuleRegion> ruleRegions) {
        ruleRegions.add((RuleRegion)this.getRegion());
    }

    protected void synthesizeDispatchHierarchy(@NonNull Node traceNode, @NonNull Relation2DispatchClass relation2dispatchClass, @NonNull Relation relation) {
        if (!relation.isIsAbstract()) {
            QVTrelationScheduleManager scheduleManager = (QVTrelationScheduleManager)this.getScheduleManager();
            Relation2TraceClass relation2TraceClass = scheduleManager.getRuleAnalysis((Rule)relation).getRule2TraceGroup().getRule2TraceClass();
            Relation2MiddleType relation2TraceInterface = this.relationAnalysis.getRule2TraceGroup().getBaseRelation2TraceGroup().getRule2TraceInterface();
            TypedModel traceTypedModel = this.relationAnalysis.getTraceTypedModel();
            ClassDatum dispatchedClassDatum = scheduleManager.getClassDatum(traceTypedModel, (Type)relation2TraceClass.getMiddleClass());
            Node dispatchedNode = this.createPredicatedNode(Utility.NON_NULL_MATCHED, RelationVerdictAnalysis.getName((Nameable)relation), dispatchedClassDatum);
            DispatchClass2TraceProperty dispatchClass2traceProperty = relation2dispatchClass.getDispatchClass2TraceProperty(relation);
            this.createNavigationEdge(Utility.NON_NULL_MATCHED, traceNode, dispatchClass2traceProperty.getTraceProperty(), dispatchedNode, false);
            Property successProperty = relation2TraceInterface.getGlobalSuccessProperty();
            this.createPredicatedSuccess(Utility.NON_NULL_MATCHED, dispatchedNode, successProperty, false);
        }
        for (Relation overridingRelation : QVTrelationUtil.getOverrides((Relation)relation)) {
            this.synthesizeDispatchHierarchy(traceNode, relation2dispatchClass, overridingRelation);
        }
    }

    public void synthesizeElements() {
        Relation2TraceGroup rule2traceGroup = this.relationAnalysis.getRule2TraceGroup();
        Relation2DispatchClass relation2dispatchClass = rule2traceGroup.getRule2DispatchClass();
        Node traceNode = this.synthesizeTraceNode(relation2dispatchClass);
        this.synthesizeDispatchHierarchy(traceNode, relation2dispatchClass, this.relation);
    }

    protected @NonNull Node synthesizeTraceNode(@NonNull Relation2DispatchClass relation2dispatchClass) {
        QVTrelationScheduleManager scheduleManager = (QVTrelationScheduleManager)this.getScheduleManager();
        TypedModel traceTypedModel = scheduleManager.getTraceTypedModel();
        ClassDatum dispatchedClassDatum = scheduleManager.getClassDatum(traceTypedModel, (Type)relation2dispatchClass.getMiddleClass());
        Node traceNode = this.createPredicatedNode(Utility.NON_NULL_MATCHED, RelationVerdictAnalysis.getName((Nameable)this.relation), dispatchedClassDatum);
        ((RuleRegion)this.region).getHeadNodes().add(traceNode);
        traceNode.setHead();
        Property successProperty = relation2dispatchClass.getDispatchSuccessProperty();
        this.createRealizedSuccess(Utility.NON_NULL_MATCHED, traceNode, successProperty, false);
        return traceNode;
    }
}

