/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.uml.editor.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.IdentityCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.ProfileApplication;
import org.eclipse.uml2.uml.UMLPlugin;
import org.eclipse.uml2.uml.editor.UMLEditorPlugin;
import org.eclipse.uml2.uml.editor.actions.UMLCommandAction;
import org.eclipse.uml2.uml.editor.dialogs.AbstractChoicesDialogDelegate;
import org.eclipse.uml2.uml.editor.dialogs.ChoicesDialog;
import org.eclipse.uml2.uml.util.UMLSwitch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplyProfileAction
extends UMLCommandAction {
    protected Command createActionCommand(EditingDomain editingDomain, Collection<?> collection) {
        if (collection.size() == 1 && collection.iterator().next() instanceof Package) {
            return IdentityCommand.INSTANCE;
        }
        return UnexecutableCommand.INSTANCE;
    }

    public void run(IAction action) {
        if (this.command != UnexecutableCommand.INSTANCE) {
            final Package package_ = (Package)this.collection.iterator().next();
            final ArrayList choiceOfValues = new ArrayList();
            ResourceSet resourceSet = package_.eResource().getResourceSet();
            for (URI profileURI : UMLPlugin.getEPackageNsURIToProfileLocationMap().values()) {
                try {
                    resourceSet.getResource(profileURI.trimFragment(), true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            for (Resource resource : resourceSet.getResources()) {
                TreeIterator allContents = resource.getAllContents();
                while (allContents.hasNext()) {
                    new UMLSwitch<Object>(){

                        public Object caseProfile(Profile profile) {
                            ProfileApplication profileApplication;
                            if (profile.isDefined() && ((profileApplication = package_.getProfileApplication(profile)) == null || profileApplication.getAppliedDefinition() != profile.getDefinition())) {
                                choiceOfValues.add(profile);
                            }
                            return profile;
                        }
                    }.doSwitch((EObject)allContents.next());
                }
            }
            Collections.sort(choiceOfValues, new UMLCommandAction.TextComparator(this));
            String label = UMLEditorPlugin.INSTANCE.getString("_UI_ApplyProfileActionCommand_label");
            final ChoicesDialog<Profile> dialog = new ChoicesDialog<Profile>(this.workbenchPart.getSite().getShell(), package_, label, new AbstractChoicesDialogDelegate<Profile>(Profile.class){

                @Override
                public String getChoicesLabelText() {
                    return UMLEditorPlugin.INSTANCE.getString("_UI_AvailableProfiles_label");
                }

                @Override
                public String getValuesLabelText() {
                    return UMLEditorPlugin.INSTANCE.getString("_UI_ProfilesToApply_label");
                }

                @Override
                public String getAddButtonText() {
                    return UMLEditorPlugin.INSTANCE.getString("_UI_Apply_label");
                }

                @Override
                public String getRemoveButtonText() {
                    return UMLEditorPlugin.INSTANCE.getString("_UI_Unapply_label");
                }

                @Override
                public ILabelProvider getLabelProvider() {
                    return ApplyProfileAction.this.getLabelProvider();
                }

                @Override
                public Collection<Profile> getChoiceOfValues() {
                    return choiceOfValues;
                }
            });
            dialog.open();
            if (dialog.getReturnCode() == 0 && !dialog.getResult().isEmpty()) {
                this.editingDomain.getCommandStack().execute((Command)new UMLCommandAction.RefreshingChangeCommand(this, this.editingDomain, new Runnable(){

                    public void run() {
                        package_.applyProfiles(dialog.getResult());
                    }
                }, label));
            }
        }
    }
}

