/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.creation;

import java.lang.reflect.Method;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.broadcast.JavaInfoMethodAssociationOnParse;
import org.eclipse.wb.core.model.broadcast.JavaInfoSetObjectAfter;
import org.eclipse.wb.core.model.broadcast.ObjectInfoDelete;
import org.eclipse.wb.core.model.broadcast.ObjectInfoPresentationDecorateIcon;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.clipboard.IClipboardImplicitCreationSupport;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.creation.IExposedCreationSupport;
import org.eclipse.wb.internal.core.model.creation.IImplicitCreationSupport;
import org.eclipse.wb.internal.core.model.description.MethodDescription;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;

public final class ExposedPropertyCreationSupport
extends CreationSupport
implements IImplicitCreationSupport,
IExposedCreationSupport {
    private static final String IS_SET_REPLACED = "ExposedPropertyCreationSupport.isSetReplaced";
    private final JavaInfo m_hostJavaInfo;
    private final Method m_getMethod;
    private final String m_getMethodSignature;
    private final String m_setMethodSignature;
    private final boolean m_direct;

    public ExposedPropertyCreationSupport(JavaInfo hostJavaInfo, Method getMethod, Method setMethod, boolean direct) {
        this.m_hostJavaInfo = hostJavaInfo;
        this.m_getMethod = getMethod;
        this.m_direct = direct;
        this.m_getMethodSignature = ReflectionUtils.getMethodSignature((Method)this.m_getMethod);
        String string = this.m_setMethodSignature = setMethod != null ? ReflectionUtils.getMethodSignature((Method)setMethod) : null;
        if (setMethod != null) {
            this.m_hostJavaInfo.addBroadcastListener(new JavaInfoMethodAssociationOnParse(){

                @Override
                public void invoke(JavaInfo parent, JavaInfo child, MethodDescription methodDescription) throws Exception {
                    if (parent == ExposedPropertyCreationSupport.this.m_hostJavaInfo && ExposedPropertyCreationSupport.this.m_setMethodSignature.equals(methodDescription.getSignature())) {
                        parent.removeChild(ExposedPropertyCreationSupport.this.m_javaInfo);
                        child.putArbitraryValue(ExposedPropertyCreationSupport.IS_SET_REPLACED, Boolean.TRUE);
                    }
                }
            });
            this.m_hostJavaInfo.addBroadcastListener(new ObjectInfoDelete(){

                public void before(ObjectInfo parent, ObjectInfo child) throws Exception {
                    Expression argument;
                    JavaInfo removingChild;
                    MethodInvocation invocation;
                    if (parent == ExposedPropertyCreationSupport.this.m_hostJavaInfo && child != ExposedPropertyCreationSupport.this.m_javaInfo && (invocation = ExposedPropertyCreationSupport.this.m_hostJavaInfo.getMethodInvocation(ExposedPropertyCreationSupport.this.m_setMethodSignature)) != null && (removingChild = ExposedPropertyCreationSupport.this.m_hostJavaInfo.getChildRepresentedBy((ASTNode)(argument = (Expression)invocation.arguments().get(0)))) != null) {
                        parent.addChild((ObjectInfo)ExposedPropertyCreationSupport.this.m_javaInfo);
                    }
                }
            });
        }
    }

    public String toString() {
        return "method: " + ReflectionUtils.toString((Method)this.m_getMethod);
    }

    @Override
    public void setJavaInfo(JavaInfo javaInfo) throws Exception {
        super.setJavaInfo(javaInfo);
        this.m_hostJavaInfo.addBroadcastListener(new JavaInfoSetObjectAfter(){

            @Override
            public void invoke(JavaInfo target, Object o) throws Exception {
                if (target == ExposedPropertyCreationSupport.this.m_hostJavaInfo && ExposedPropertyCreationSupport.this.m_javaInfo.getObject() == null) {
                    Object object;
                    try {
                        object = ReflectionUtils.invokeMethod((Method)ExposedPropertyCreationSupport.this.m_getMethod, (Object)o, (Object[])new Object[0]);
                    }
                    catch (Throwable e) {
                        object = null;
                    }
                    if (object != null) {
                        ExposedPropertyCreationSupport.this.m_javaInfo.setObject(object);
                    }
                }
            }
        });
        this.m_javaInfo.addBroadcastListener(new ObjectInfoPresentationDecorateIcon(){

            public void invoke(ObjectInfo object, ImageDescriptor[] icon) throws Exception {
                if (object == ExposedPropertyCreationSupport.this.m_javaInfo) {
                    ImageDescriptor decorator = DesignerPlugin.getImageDescriptor((String)"exposed/decorator.gif");
                    icon[0] = new DecorationOverlayIcon(icon[0], decorator, 3);
                }
            }
        });
    }

    @Override
    public boolean isJavaInfo(ASTNode node) {
        if (node instanceof MethodInvocation) {
            MethodInvocation invocation = (MethodInvocation)node;
            return invocation.arguments().isEmpty() && invocation.getName().getIdentifier().equals(this.m_getMethod.getName()) && this.m_hostJavaInfo.isRepresentedBy((ASTNode)invocation.getExpression());
        }
        return false;
    }

    @Override
    public ASTNode getNode() {
        return this.m_hostJavaInfo.getCreationSupport().getNode();
    }

    @Override
    public JavaInfo getHostJavaInfo() {
        return this.m_hostJavaInfo;
    }

    public Method getMethod() {
        return this.m_getMethod;
    }

    @Override
    public boolean isDirect() {
        return this.m_direct;
    }

    public static boolean isReplacementForExposed(JavaInfo javaInfo) {
        return javaInfo.getArbitraryValue(IS_SET_REPLACED) != null;
    }

    @Override
    public boolean canDelete() {
        return true;
    }

    @Override
    public void delete() throws Exception {
        JavaInfoUtils.deleteJavaInfo(this.m_javaInfo, false);
    }

    @Override
    public IClipboardImplicitCreationSupport getImplicitClipboard() {
        final String getMethodSignature = this.m_getMethodSignature;
        return new IClipboardImplicitCreationSupport(){
            private static final long serialVersionUID = 0L;

            @Override
            public JavaInfo find(JavaInfo host) throws Exception {
                for (JavaInfo child : host.getChildrenJava()) {
                    if (!(child.getCreationSupport() instanceof ExposedPropertyCreationSupport)) continue;
                    ExposedPropertyCreationSupport exposedCreation = (ExposedPropertyCreationSupport)child.getCreationSupport();
                    if (!exposedCreation.m_getMethodSignature.equals(getMethodSignature)) continue;
                    return child;
                }
                return null;
            }
        };
    }
}

