/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.runtime;

import java.io.File;
import org.eclipse.wst.jsdt.core.runtime.IJSRunner;
import org.eclipse.wst.jsdt.core.runtime.IJSRuntimeInstall;
import org.eclipse.wst.jsdt.core.runtime.IJSRuntimeType;
import org.eclipse.wst.jsdt.internal.core.runtime.RuntimeMessages;
import org.eclipse.wst.jsdt.launching.ExecutionArguments;

public abstract class AbstractJSRuntimeInstall
implements IJSRuntimeInstall {
    protected String fId;
    protected String fName;
    protected File fInstallLocation;
    protected String fRuntimeArgs;
    private IJSRuntimeType fType;

    public AbstractJSRuntimeInstall(IJSRuntimeType type, String id) {
        if (id == null) {
            throw new IllegalArgumentException(RuntimeMessages.AbstractJSRuntimeInstall_MissingId_Error);
        }
        if (type == null) {
            throw new IllegalArgumentException(RuntimeMessages.AbstractJSRuntimeInstall_MissingType_Error);
        }
        this.fId = id;
        this.fType = type;
    }

    @Override
    public String getId() {
        return this.fId;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException(RuntimeMessages.AbstractJSRuntimeInstall_MissingName_Error);
        }
        this.fName = name;
    }

    @Override
    public File getInstallLocation() {
        return this.fInstallLocation;
    }

    @Override
    public void setInstallLocation(File installLocation) {
        this.fInstallLocation = installLocation;
    }

    @Override
    public IJSRunner getJSRunner(String mode) {
        return null;
    }

    @Override
    public String[] getJSRuntimeArguments() {
        String args = this.fRuntimeArgs;
        if (args == null) {
            return null;
        }
        ExecutionArguments ex = new ExecutionArguments(args, "");
        return ex.getVMArgumentsArray();
    }

    @Override
    public String getJSRuntimeArgumentsAsString() {
        return this.fRuntimeArgs;
    }

    @Override
    public void setJSRuntimeArguments(String runtimeArgs) {
        this.fRuntimeArgs = runtimeArgs;
    }

    @Override
    public IJSRuntimeType getRuntimeType() {
        return this.fType;
    }

    public boolean equals(Object object) {
        if (object instanceof IJSRuntimeInstall) {
            IJSRuntimeInstall runtime = (IJSRuntimeInstall)object;
            return this.getRuntimeType().equals(runtime.getRuntimeType()) && this.getId().equals(runtime.getId());
        }
        return false;
    }

    public int hashCode() {
        return this.getRuntimeType().hashCode() + this.getId().hashCode();
    }
}

