/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.reconcile.validator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.sse.ui.internal.reconcile.validator.AnnotationInfo;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;

public class IncrementalReporter
implements IReporter {
    private IProgressMonitor fProgressMonitor;
    private HashMap messages = new HashMap();

    public IncrementalReporter(IProgressMonitor progressMonitor) {
        this.fProgressMonitor = progressMonitor;
    }

    public void addMessage(IValidator validator, IMessage message) {
        AnnotationInfo info = new AnnotationInfo(message);
        this.addAnnotationInfo(validator, info);
    }

    public final void addAnnotationInfo(IValidator validator, AnnotationInfo info) {
        Object existingValue = this.messages.get(validator);
        if (existingValue != null) {
            ((HashSet)existingValue).add(info);
        } else {
            HashSet<AnnotationInfo> newValue = new HashSet<AnnotationInfo>(1);
            newValue.add(info);
            this.messages.put(validator, newValue);
        }
    }

    public void displaySubtask(IValidator validator, IMessage message) {
        if (message == null || message.equals("")) {
            return;
        }
        if (this.fProgressMonitor != null) {
            this.fProgressMonitor.subTask(message.getText(validator.getClass().getClassLoader()));
        }
    }

    public List getMessages() {
        ArrayList<IMessage> result = new ArrayList<IMessage>();
        Object[] lists = this.messages.values().toArray();
        int i = 0;
        while (i < lists.length) {
            for (AnnotationInfo info : (HashSet)lists[i]) {
                result.add(info.getMessage());
            }
            ++i;
        }
        return result;
    }

    public AnnotationInfo[] getAnnotationInfo() {
        ArrayList result = new ArrayList();
        Object[] infos = this.messages.values().toArray();
        int i = 0;
        while (i < infos.length) {
            result.addAll((HashSet)infos[i]);
            ++i;
        }
        return result.toArray(new AnnotationInfo[result.size()]);
    }

    public boolean isCancelled() {
        if (this.fProgressMonitor == null) {
            return false;
        }
        return this.fProgressMonitor.isCanceled();
    }

    public void removeAllMessages(IValidator validator) {
        Object o = this.messages.get(validator);
        if (o != null && o instanceof HashSet) {
            ((HashSet)o).clear();
        }
    }

    public void removeAllMessages(IValidator validator, Object object) {
        this.removeAllMessages(validator);
    }

    public void removeMessageSubset(IValidator validator, Object obj, String groupName) {
        this.removeAllMessages(validator);
    }
}

