/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.core.codeassist;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.Argument;
import org.eclipse.dltk.ast.declarations.FieldDeclaration;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.ast.statements.Block;
import org.eclipse.dltk.codeassist.AssistParser;
import org.eclipse.dltk.codeassist.IAssistParser;
import org.eclipse.dltk.codeassist.ScriptSelectionEngine;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IParent;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.mixin.IMixinElement;
import org.eclipse.dltk.core.mixin.IMixinRequestor;
import org.eclipse.dltk.internal.codeassist.select.SelectionNodeFound;
import org.eclipse.dltk.tcl.ast.ITclStatementLookLike;
import org.eclipse.dltk.tcl.ast.TclStatement;
import org.eclipse.dltk.tcl.core.TclLanguageToolkit;
import org.eclipse.dltk.tcl.core.TclParseUtil;
import org.eclipse.dltk.tcl.core.extensions.ISelectionExtension;
import org.eclipse.dltk.tcl.internal.core.TclExtensionManager;
import org.eclipse.dltk.tcl.internal.core.codeassist.TclResolver;
import org.eclipse.dltk.tcl.internal.core.codeassist.TclSelectionParser;
import org.eclipse.dltk.tcl.internal.core.codeassist.selection.SelectionOnAST;
import org.eclipse.dltk.tcl.internal.core.codeassist.selection.SelectionOnKeywordOrFunction;
import org.eclipse.dltk.tcl.internal.core.codeassist.selection.SelectionOnNode;
import org.eclipse.dltk.tcl.internal.core.codeassist.selection.SelectionOnVariable;
import org.eclipse.dltk.tcl.internal.core.packages.TclBuildPathPackageCollector;
import org.eclipse.dltk.tcl.internal.core.search.mixin.TclMixinModel;
import org.eclipse.dltk.tcl.internal.core.search.mixin.model.TclField;
import org.eclipse.dltk.tcl.internal.core.search.mixin.model.TclNamespaceImport;
import org.eclipse.dltk.tcl.internal.core.search.mixin.model.TclProc;
import org.eclipse.dltk.tcl.internal.parser.OldTclParserUtils;

public class TclSelectionEngine
extends ScriptSelectionEngine {
    public static boolean DEBUG = DLTKCore.DEBUG_SELECTION;
    protected int actualSelectionStart;
    protected int actualSelectionEnd;
    protected List<IModelElement> selectionElements = new ArrayList<IModelElement>();
    protected AssistParser parser = new AssistParser((IAssistParser)new TclSelectionParser());
    protected ISourceModule sourceModule;
    protected IDLTKLanguageToolkit toolkit;
    protected ISelectionExtension[] extensions;
    private TclBuildPathPackageCollector packageCollector;
    TclResolver.IResolveElementParent parentResolver = (node, name, parent) -> this.findElementParent(node, name, parent);

    public TclSelectionEngine() {
        this.toolkit = TclLanguageToolkit.getDefault();
        this.extensions = TclExtensionManager.getDefault().getSelectionExtensions();
    }

    public IModelElement[] select(IModuleSource sourceUnit, int selectionSourceStart, int selectionSourceEnd) {
        block14: {
            this.sourceModule = (ISourceModule)sourceUnit.getModelElement();
            String content = sourceUnit.getSourceContents();
            if (DEBUG) {
                System.out.print("SELECTION IN ");
                System.out.print(sourceUnit.getFileName());
                System.out.print(" FROM ");
                System.out.print(selectionSourceStart);
                System.out.print(" TO ");
                System.out.println(selectionSourceEnd);
                System.out.println("SELECTION - Source :");
                System.out.println(content);
            }
            if (!this.checkSelection(content, selectionSourceStart, selectionSourceEnd)) {
                return new IModelElement[0];
            }
            if (DEBUG) {
                System.out.print("SELECTION - Checked : \"");
                System.out.print(content.substring(this.actualSelectionStart, this.actualSelectionEnd));
                System.out.println('\"');
            }
            try {
                ModuleDeclaration parsedUnit;
                block13: {
                    parsedUnit = this.parser.parse(sourceUnit);
                    this.packageCollector = new TclBuildPathPackageCollector();
                    try {
                        parsedUnit.traverse((ASTVisitor)this.packageCollector);
                    }
                    catch (Exception e1) {
                        if (!DLTKCore.DEBUG) break block13;
                        e1.printStackTrace();
                    }
                }
                if (parsedUnit == null) break block14;
                try {
                    this.parser.parseBlockStatements(parsedUnit, this.actualSelectionStart);
                    if (DEBUG) {
                        System.out.println("COMPLETION - AST :");
                        System.out.println(parsedUnit.toString());
                    }
                }
                catch (SelectionNodeFound e) {
                    if (e.getNode() != null) {
                        if (DEBUG) {
                            System.out.print("COMPLETION - Completion node : ");
                            System.out.println(e.getNode().toString());
                            if (this.parser.getAssistNodeParent() != null) {
                                System.out.print("COMPLETION - Parent Node : ");
                                System.out.println(this.parser.getAssistNodeParent());
                            }
                        }
                        this.select(e.getNode(), this.parser.getAssistNodeParent());
                    }
                }
            }
            catch (IndexOutOfBoundsException e) {
                if (!DEBUG) break block14;
                System.out.println("Exception caught by SelectionEngine:");
                e.printStackTrace(System.out);
            }
        }
        return this.selectionElements.toArray(new IModelElement[this.selectionElements.size()]);
    }

    protected ASTNode parseBlockStatements(TypeDeclaration type, ModuleDeclaration unit, int position) {
        ASTNode result = this.parser.parseBlockStatements(type, unit, position);
        if (result != null) {
            return result;
        }
        if (type instanceof ITclStatementLookLike) {
            TclStatement statement = ((ITclStatementLookLike)type).getStatement();
            ASTNode inNode = TclParseUtil.getScopeParent(this.parser.getModule(), (ASTNode)type);
            this.getAssistParser().parseBlockStatements((ASTNode)statement, inNode, position);
            SelectionOnNode nde = new SelectionOnNode((ASTNode)type);
            nde.setPosition(position);
            throw new SelectionNodeFound((ASTNode)nde);
        }
        return null;
    }

    protected void select(ASTNode astNode, ASTNode astNodeParent) {
        block12: {
            block14: {
                block13: {
                    block11: {
                        if (!(astNode instanceof SelectionOnKeywordOrFunction)) break block11;
                        SelectionOnKeywordOrFunction key = (SelectionOnKeywordOrFunction)astNode;
                        String name = key.getName();
                        if (name != null) {
                            TypeDeclaration t;
                            this.findLocalFunctions(name, astNodeParent);
                            if (this.selectionElements.size() > 0) {
                                return;
                            }
                            this.findMethodFromMixin(name);
                            String fqnName = null;
                            if (astNodeParent instanceof TypeDeclaration) {
                                t = (TypeDeclaration)astNodeParent;
                                fqnName = String.valueOf(t.getEnclosingTypeName()) + "::" + t.getName() + "::" + name;
                            } else if (astNodeParent instanceof MethodDeclaration) {
                                t = (MethodDeclaration)astNodeParent;
                                fqnName = String.valueOf(t.getDeclaringTypeName()) + "::" + name;
                            }
                            if (fqnName != null) {
                                if (!fqnName.startsWith("::")) {
                                    fqnName = "::" + fqnName;
                                }
                                this.findMethodFromMixin(name);
                            }
                            String currentNamespace = TclParseUtil.getElementFQN(astNodeParent, "::", this.getAssistParser().getModule());
                            HashSet processed = new HashSet();
                            this.selectNamespaceImport(name, currentNamespace, processed);
                            if (!currentNamespace.equals("")) {
                                this.selectNamespaceImport(name, "", processed);
                            }
                        }
                        int i = 0;
                        while (i < this.extensions.length) {
                            this.extensions[i].selectionOnKeywordOrFunction(key, this);
                            ++i;
                        }
                        break block12;
                    }
                    if (!(astNode instanceof SelectionOnVariable)) break block13;
                    SelectionOnVariable completion = (SelectionOnVariable)astNode;
                    this.findVariables(completion.getName(), astNodeParent, astNode.sourceStart());
                    break block12;
                }
                if (!(astNode instanceof SelectionOnAST)) break block14;
                ASTNode node = ((SelectionOnAST)astNode).getNode();
                int i = 0;
                while (i < this.extensions.length) {
                    this.extensions[i].selectionOnAST(node, this);
                    ++i;
                }
                this.addElementFromASTNode(node);
                break block12;
            }
            if (!(astNode instanceof SelectionOnNode)) break block12;
            ASTNode node = ((SelectionOnNode)astNode).getNode();
            int position = ((SelectionOnNode)astNode).getPosition();
            int i = 0;
            while (i < this.extensions.length) {
                this.extensions[i].selectionOnNode(node, position, this);
                ++i;
            }
        }
    }

    private void selectNamespaceImport(String name, String currentNamespace, Set processed) {
        String pattern = "@" + currentNamespace + "|*";
        String[] findKeys = TclMixinModel.getInstance().getMixin(this.getScriptProject()).findKeys(pattern);
        HashSet<String> keys = new HashSet<String>();
        int i = 0;
        while (i < findKeys.length) {
            TclNamespaceImport importSt;
            if (keys.add(findKeys[i]) && (importSt = TclNamespaceImport.parseKey(findKeys[i])).getNamespace().equals(currentNamespace) && processed.add(importSt.getImportNsName())) {
                this.findMethodFromMixinNS(String.valueOf(importSt.getImportNsName()) + "::" + name, importSt.getImportNsName());
            }
            ++i;
        }
    }

    protected void findMethodFromMixin(String name) {
        if (name.startsWith("::") && name.startsWith("::")) {
            name = name.substring(2);
        }
        String oName = name;
        if (name.indexOf("::") != -1) {
            String[] split = TclParseUtil.tclSplit(name);
            oName = split[split.length - 1];
        }
        this.findMethodMixin(this.tclNameToKey(name), oName);
    }

    protected void findMethodFromMixinNS(String name, String namespace) {
        if (name.startsWith("::") && name.startsWith("::")) {
            name = name.substring(2);
        }
        String oName = name;
        if (name.indexOf("::") != -1) {
            String[] split = TclParseUtil.tclSplit(name);
            oName = split[split.length - 1];
        }
        this.findMethodMixinNS(this.tclNameToKey(name), oName, namespace);
    }

    public boolean checkMethodFrom(TypeDeclaration declaringType, SimpleReference callName, IModelElement parent) {
        List methodList = declaringType.getMethodList();
        for (MethodDeclaration method : methodList) {
            if (!method.getName().equals(callName.toString())) continue;
            IModelElement methodElement = TclResolver.findChildrenByName(method.getName(), (IParent)parent);
            this.addSelectionElement(methodElement);
            return true;
        }
        return false;
    }

    public void fillSuperClassesTo(TypeDeclaration declaringType, List supersToHandle) {
        if (declaringType == null) {
            return;
        }
        if (declaringType.getSuperClasses() == null) {
            return;
        }
        List superClasses = declaringType.getSuperClasses().getChilds();
        int i = 0;
        while (i < superClasses.size()) {
            String superClassName = TclParseUtil.getNameFromNode((ASTNode)superClasses.get(i));
            if (superClassName != null) {
                supersToHandle.add(superClassName);
            }
            ++i;
        }
    }

    protected void findVariables(String name, ASTNode parent, int beforePosition) {
        String originalName = name;
        int i = 0;
        while (i < this.extensions.length) {
            this.extensions[i].findVariables(name, parent, beforePosition, this);
            if (this.selectionElements.size() > 0) {
                return;
            }
            ++i;
        }
        if (parent instanceof MethodDeclaration) {
            MethodDeclaration method = (MethodDeclaration)parent;
            List statements = method.getArguments();
            if (statements != null) {
                int i2 = 0;
                while (i2 < statements.size()) {
                    Argument a = (Argument)statements.get(i2);
                    if (a != null) {
                        this.checkVariable(name, a.getName(), (ASTNode)method);
                    }
                    ++i2;
                }
            }
            statements = method.getStatements();
            this.checkVariableStatements(name, beforePosition, statements, "");
        } else if (parent instanceof ModuleDeclaration) {
            ModuleDeclaration module = (ModuleDeclaration)parent;
            this.checkVariableStatements(name, beforePosition, module.getStatements(), "");
        } else if (parent instanceof TypeDeclaration) {
            TypeDeclaration type = (TypeDeclaration)parent;
            this.checkVariableStatements(name, beforePosition, type.getStatements(), "");
        } else {
            List<ASTNode> levels = TclParseUtil.findLevelsTo(this.parser.getModule(), parent);
            ASTNode realParent = this.findRealParent(levels);
            if (realParent != null) {
                this.findVariables(name, realParent, beforePosition);
            }
        }
        if (this.selectionElements.size() > 0) {
            return;
        }
        if (name.startsWith("$")) {
            block19: {
                if (!(name = name.substring(1)).startsWith("::")) {
                    name = "::" + name;
                }
                String typeName = name.substring(0, name.lastIndexOf("::"));
                String varName = name.substring(name.lastIndexOf("::") + 2);
                typeName = typeName.replaceAll("::", "\\$");
                try {
                    IModelElement field;
                    Object type = null;
                    type = typeName.length() > 0 ? (IModelElement)TclResolver.findTypeFrom(this.sourceModule.getChildren(), "", typeName, '$') : this.sourceModule;
                    if (type != null && type instanceof IParent && (field = TclResolver.findChildrenByName(varName, (IParent)type)) != null) {
                        this.addSelectionElement(field);
                    }
                }
                catch (ModelException e) {
                    if (!DLTKCore.DEBUG) break block19;
                    e.printStackTrace();
                }
            }
            this.findFieldFromMixin(parent, name);
        }
        if (this.selectionElements.size() > 0) {
            return;
        }
        this.findFieldFromMixin(parent, originalName);
    }

    protected void findFieldFromMixin(ASTNode parent, String name) {
        if (name.startsWith("$")) {
            name = name.substring(1);
        }
        if (name.startsWith("{") || name.endsWith("}")) {
            name = name.substring(1, name.length() - 1);
        }
        if (parent instanceof ModuleDeclaration || name.startsWith("::")) {
            if (name.startsWith("::")) {
                name = name.substring(2);
            }
            String oName = name;
            if (name.indexOf("::") != -1) {
                String[] split = TclParseUtil.tclSplit(name);
                oName = split[split.length - 1];
            }
            this.findFieldMixin(this.tclNameToKey(name), oName);
        } else {
            List<ASTNode> levels = TclParseUtil.findLevelsTo(this.parser.getModule(), parent);
            String keyFromLevels = this.getKeyFromLevels(levels);
            this.findFieldMixin(String.valueOf(keyFromLevels) + IMixinRequestor.MIXIN_NAME_SEPARATOR + name, name);
        }
    }

    public String tclNameToKey(String name) {
        return TclParseUtil.tclNameTo(name, IMixinRequestor.MIXIN_NAME_SEPARATOR);
    }

    protected void findFieldMixin(String pattern, String name) {
        IMixinElement[] find = TclMixinModel.getInstance().getMixin(this.sourceModule.getScriptProject()).find(pattern);
        int i = 0;
        while (i < find.length) {
            Object[] allObjects = find[i].getAllObjects();
            int j = 0;
            while (j < allObjects.length) {
                TclField field;
                if (allObjects[j] != null && allObjects[j] instanceof TclField && name.equals((field = (TclField)allObjects[j]).getName())) {
                    this.addSelectionElement(field.getModelElement());
                    return;
                }
                ++j;
            }
            ++i;
        }
    }

    public void findMethodMixin(String pattern, String name) {
        IMixinElement[] find = TclMixinModel.getInstance().getMixin(this.sourceModule.getScriptProject()).find(pattern);
        ArrayList<IModelElement> selections = new ArrayList<IModelElement>();
        int i = 0;
        while (i < find.length) {
            Object[] allObjects = find[i].getAllObjects();
            int j = 0;
            while (j < allObjects.length) {
                TclProc field;
                if (allObjects[j] != null && allObjects[j] instanceof TclProc && name.equals((field = (TclProc)allObjects[j]).getName())) {
                    selections.add(field.getModelElement());
                }
                ++j;
            }
            ++i;
        }
        IModelElement[] result = TclResolver.complexFilter(selections.toArray(new IModelElement[selections.size()]), this.getScriptProject(), this.packageCollector, true);
        int i2 = 0;
        while (i2 < result.length) {
            this.addSelectionElement(result[i2]);
            ++i2;
        }
    }

    public void findMethodMixinNS(String pattern, String name, String namespace) {
        if (!namespace.startsWith("::")) {
            namespace = "::" + namespace;
        }
        if (!namespace.endsWith("::")) {
            namespace = String.valueOf(namespace) + "::";
        }
        IMixinElement[] find = TclMixinModel.getInstance().getMixin(this.sourceModule.getScriptProject()).find(pattern);
        int i = 0;
        while (i < find.length) {
            Object[] allObjects = find[i].getAllObjects();
            int j = 0;
            while (j < allObjects.length) {
                TclProc field;
                if (allObjects[j] != null && allObjects[j] instanceof TclProc && name.equals((field = (TclProc)allObjects[j]).getName())) {
                    IModelElement element = field.getModelElement();
                    String fqn = TclParseUtil.getFQNFromModelElement(element, "::");
                    if (fqn.startsWith(namespace)) {
                        String substring = fqn.substring(namespace.length());
                        if (substring.indexOf("::") == -1) {
                            this.addSelectionElement(element);
                        }
                    } else {
                        this.addSelectionElement(element);
                    }
                    return;
                }
                ++j;
            }
            ++i;
        }
    }

    protected String getKeyFromLevels(List nodes) {
        return TclParseUtil.getElementFQN(nodes, IMixinRequestor.MIXIN_NAME_SEPARATOR, this.parser.getModule());
    }

    protected ASTNode findRealParent(List levels) {
        int i = levels.size() - 1;
        while (i >= 0) {
            ASTNode n = (ASTNode)levels.get(i);
            if (n instanceof MethodDeclaration || n instanceof TypeDeclaration || n instanceof ModuleDeclaration) {
                return n;
            }
            --i;
        }
        return null;
    }

    protected void checkVariableStatements(String name, int beforePosition, List statements, String prefix) {
        if (statements != null) {
            int i = 0;
            while (i < statements.size()) {
                List statements2;
                TclStatement s;
                String[] variable;
                ASTNode node = (ASTNode)statements.get(i);
                if (node instanceof FieldDeclaration) {
                    FieldDeclaration decl = (FieldDeclaration)node;
                    this.checkVariable(name, String.valueOf(prefix) + decl.getName(), node);
                }
                if (node instanceof TclStatement && node.sourceEnd() < beforePosition && (variable = OldTclParserUtils.returnVariable(s = (TclStatement)node)) != null) {
                    int u = 0;
                    while (u < variable.length) {
                        this.checkVariable(name, String.valueOf(prefix) + variable[u], node);
                        ++u;
                    }
                }
                if (node instanceof TypeDeclaration) {
                    TypeDeclaration type = (TypeDeclaration)node;
                    String nn = type.getName();
                    if (nn.startsWith("::")) {
                        nn = nn.substring(2);
                    }
                    this.checkVariableStatements(name, beforePosition, type.getStatements(), String.valueOf(prefix) + nn + "::");
                } else if (node.sourceStart() <= beforePosition && (statements2 = TclResolver.findExtractBlocks(node)).size() != 0) {
                    this.checkVariableStatements(name, beforePosition, statements2, prefix);
                }
                ++i;
            }
        }
    }

    private void checkVariable(String name, String variable, ASTNode node) {
        if (variable.indexOf(40) != -1) {
            variable = variable.substring(0, variable.indexOf(40));
        }
        String str = name.startsWith("${") ? "${" + variable + '}' : "$" + variable;
        if (name.indexOf(40) != -1) {
            name = name.substring(0, name.indexOf(40));
        }
        if (name.equals(str)) {
            this.addElementFromASTNode(node);
        }
    }

    protected void findLocalFunctions(String name, ASTNode parent) {
        MethodDeclaration mParent;
        String pName;
        List<ASTNode> levels = TclParseUtil.findLevelsTo(this.parser.getModule(), parent);
        int len = levels.size();
        ASTNode realParent = this.findRealParent(levels);
        if (realParent instanceof MethodDeclaration && !name.startsWith("::") && (pName = (mParent = (MethodDeclaration)realParent).getName()).indexOf("::") != -1) {
            pName = pName.substring(0, pName.lastIndexOf("::") + 2);
            this.processFindLocalFunctions(String.valueOf(pName) + name, levels, len);
        }
        this.processFindLocalFunctions(name, levels, len);
    }

    protected void processFindLocalFunctions(String name, List levels, int len) {
        ArrayList visited = new ArrayList();
        int j = 0;
        while (j < len) {
            List statements;
            TypeDeclaration decl;
            ASTNode astNodeParent = (ASTNode)levels.get(len - 1 - j);
            boolean topLevel = false;
            if (name != null && name.length() > 0 && name.charAt(0) == ':') {
                topLevel = true;
            }
            if (astNodeParent instanceof TypeDeclaration && !topLevel) {
                decl = (TypeDeclaration)astNodeParent;
                statements = decl.getStatements();
                if (statements != null) {
                    this.processMethods(name, statements, "", visited);
                    if (!name.startsWith("::")) {
                        this.processMethods(String.valueOf(decl.getName()) + "::" + name, statements, "", visited);
                    }
                    if (this.selectionElements.size() > 0) {
                        return;
                    }
                }
            } else if (astNodeParent instanceof ModuleDeclaration) {
                decl = (ModuleDeclaration)astNodeParent;
                statements = decl.getStatements();
                this.processMethods(name, statements, "", visited);
                if (statements != null && this.selectionElements.size() > 0) {
                    return;
                }
            }
            ++j;
        }
    }

    protected void processMethods(String name, List statements, final String namePrefix, final List visited) {
        if (this.selectionElements.size() > 0) {
            return;
        }
        int i = 0;
        while (i < statements.size()) {
            ASTNode nde;
            block16: {
                nde = (ASTNode)statements.get(i);
                if (nde instanceof MethodDeclaration) {
                    String mName = ((MethodDeclaration)nde).getName();
                    if (!mName.startsWith("::")) {
                        mName = String.valueOf(namePrefix) + mName;
                    }
                    if (mName.startsWith("::::")) {
                        mName = mName.substring(2);
                    }
                    if (name.startsWith("::")) {
                        name = name.substring(2);
                    }
                    if (mName.startsWith("::")) {
                        mName = mName.substring(2);
                    }
                    if (name.equals(mName)) {
                        this.addElementFromASTNode(nde);
                        if (this.selectionElements.size() > 0) {
                            return;
                        }
                    }
                } else if (nde instanceof TypeDeclaration && !visited.contains(nde)) {
                    List tStatements = ((TypeDeclaration)nde).getStatements();
                    visited.add(nde);
                    String ndeName = ((TypeDeclaration)nde).getName();
                    if (ndeName.startsWith("::")) {
                        this.processMethods(name, tStatements, String.valueOf(ndeName) + "::", visited);
                    } else {
                        this.processMethods(name, tStatements, String.valueOf(namePrefix) + ndeName + "::", visited);
                    }
                } else {
                    final String fname = name;
                    ASTVisitor visitor = new ASTVisitor(){

                        public boolean visit(Expression s) throws Exception {
                            if (s instanceof Block) {
                                List tStatements = ((Block)s).getStatements();
                                visited.add(s);
                                TclSelectionEngine.this.processMethods(fname, tStatements, namePrefix, visited);
                            }
                            return false;
                        }

                        public boolean visit(MethodDeclaration s) throws Exception {
                            return false;
                        }

                        public boolean visit(TypeDeclaration s) throws Exception {
                            return false;
                        }
                    };
                    try {
                        nde.traverse(visitor);
                    }
                    catch (Exception e) {
                        if (!DLTKCore.DEBUG) break block16;
                        e.printStackTrace();
                    }
                }
            }
            visited.add(nde);
            ++i;
        }
    }

    public void addElementFromASTNode(ASTNode nde) {
        ModuleDeclaration module = this.parser.getModule();
        List statements = module.getStatements();
        new TclResolver(this.sourceModule, this.parser.getModule(), this.parentResolver).searchAddElementsTo(statements, nde, (IParent)this.sourceModule, this.selectionElements);
    }

    public IModelElement findElementFromNode(ASTNode nde) {
        ModuleDeclaration module = this.parser.getModule();
        List statements = module.getStatements();
        ArrayList<IModelElement> elements = new ArrayList<IModelElement>();
        new TclResolver(this.sourceModule, this.parser.getModule(), this.parentResolver).searchAddElementsTo(statements, nde, (IParent)this.sourceModule, elements);
        if (elements.size() == 1) {
            return (IModelElement)elements.get(0);
        }
        return null;
    }

    protected IModelElement findElementParent(ASTNode node, String name, IParent parent) {
        int i = 0;
        while (i < this.extensions.length) {
            IModelElement pel = this.extensions[i].findElementParent(node, name, parent, this);
            if (pel != null) {
                return pel;
            }
            ++i;
        }
        return null;
    }

    protected boolean checkSelection(String source, int selectionSourceStart, int selectionSourceEnd) {
        boolean cheat = false;
        if (selectionSourceEnd < selectionSourceStart) {
            selectionSourceEnd = selectionSourceStart;
            cheat = true;
        }
        int start = OldTclParserUtils.startLineOrNoSymbol(selectionSourceStart, source);
        int end = OldTclParserUtils.endLineOrNoSymbol(selectionSourceEnd, source);
        if (end <= start) {
            if (cheat) {
                return this.checkSelection(source, selectionSourceEnd - 1, selectionSourceEnd - 1);
            }
            return false;
        }
        if (start > source.length() || end > source.length()) {
            if (cheat) {
                return this.checkSelection(source, selectionSourceEnd - 1, selectionSourceEnd - 1);
            }
            return false;
        }
        boolean isVariable = false;
        if (source.charAt(start) == '$') {
            isVariable = true;
        } else if (start > 0 && source.charAt(start - 1) == '{' && start - 1 > 0 && source.charAt(start - 2) == '$') {
            start -= 2;
            isVariable = true;
            while (end < source.length() && source.charAt(end) != '}') {
                ++end;
            }
            if (end < source.length()) {
                ++end;
            }
        }
        if (isVariable && end < source.length() && source.charAt(end) == '(') {
            while (end < source.length() && source.charAt(end) != ')') {
                ++end;
            }
            if (end < source.length()) {
                ++end;
            }
        }
        if (isVariable && start + 1 < source.length() && source.charAt(start + 1) == '{') {
            int pos = start;
            while (pos < source.length() && source.charAt(pos) != '}') {
                ++pos;
            }
            if (pos < source.length()) {
                ++pos;
            }
            end = pos;
        }
        if (start > end || end > source.length()) {
            System.out.println();
        }
        String sub = source.substring(start, end);
        if (!isVariable && sub.endsWith("}")) {
            int pos = end;
            while (pos > 0) {
                if (source.charAt(pos) == '{') break;
                --pos;
            }
            if (pos > 0 && source.charAt(pos - 1) == '$') {
                isVariable = true;
                start = pos - 1;
                sub = source.substring(start, end);
            }
        }
        if (!(isVariable || sub.indexOf(32) == -1 && sub.indexOf(9) == -1 && sub.indexOf(10) == -1)) {
            if (cheat) {
                return this.checkSelection(source, selectionSourceEnd - 1, selectionSourceEnd - 1);
            }
            return false;
        }
        this.actualSelectionStart = start;
        this.actualSelectionEnd = end;
        return true;
    }

    public IAssistParser getAssistParser() {
        return this.parser;
    }

    public IParent getSourceModule() {
        return this.sourceModule;
    }

    public IScriptProject getScriptProject() {
        return this.sourceModule.getScriptProject();
    }

    public int getActualSelectionStart() {
        return this.actualSelectionStart;
    }

    public void addSelectionElement(IModelElement element) {
        if (!this.selectionElements.contains(element)) {
            this.selectionElements.add(element);
        }
    }

    public int getSelectionElementsSize() {
        return this.selectionElements.size();
    }
}

