/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.security.provider;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.cdo.security.Access;
import org.eclipse.emf.cdo.security.FilterPermission;
import org.eclipse.emf.cdo.security.PermissionFilter;
import org.eclipse.emf.cdo.security.SecurityFactory;
import org.eclipse.emf.cdo.security.SecurityPackage;
import org.eclipse.emf.cdo.security.provider.PermissionItemProvider;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;

public class FilterPermissionItemProvider
extends PermissionItemProvider {
    public FilterPermissionItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
        }
        return this.itemPropertyDescriptors;
    }

    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            super.getChildrenFeatures(object);
            this.childrenFeatures.add(SecurityPackage.Literals.FILTER_PERMISSION__FILTERS);
        }
        return this.childrenFeatures;
    }

    protected EStructuralFeature getChildFeature(Object object, Object child) {
        return super.getChildFeature(object, child);
    }

    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/FilterPermission"));
    }

    @Override
    protected boolean shouldComposeCreationImage() {
        return true;
    }

    @Override
    public String getText(Object object) {
        FilterPermission permission = (FilterPermission)object;
        Access access = permission.getAccess();
        EList filters = permission.getFilters();
        StringBuilder builder = new StringBuilder();
        builder.append((Object)(access == null ? "?" : access));
        int size = filters.size();
        if (size == 1) {
            builder.append(" ");
            builder.append(((PermissionFilter)filters.get(0)).format());
        } else if (size > 1) {
            builder.append(" And(");
            Iterator iterator = filters.iterator();
            builder.append(((PermissionFilter)iterator.next()).format());
            while (iterator.hasNext()) {
                builder.append(", ");
                builder.append(((PermissionFilter)iterator.next()).format());
            }
            builder.append(")");
        }
        return builder.toString();
    }

    @Override
    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(FilterPermission.class)) {
            case 2: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    @Override
    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
        newChildDescriptors.add(this.createChildParameter(SecurityPackage.Literals.FILTER_PERMISSION__FILTERS, SecurityFactory.eINSTANCE.createLinkedFilter()));
        newChildDescriptors.add(this.createChildParameter(SecurityPackage.Literals.FILTER_PERMISSION__FILTERS, SecurityFactory.eINSTANCE.createPackageFilter()));
        newChildDescriptors.add(this.createChildParameter(SecurityPackage.Literals.FILTER_PERMISSION__FILTERS, SecurityFactory.eINSTANCE.createClassFilter()));
        newChildDescriptors.add(this.createChildParameter(SecurityPackage.Literals.FILTER_PERMISSION__FILTERS, SecurityFactory.eINSTANCE.createResourceFilter()));
        newChildDescriptors.add(this.createChildParameter(SecurityPackage.Literals.FILTER_PERMISSION__FILTERS, SecurityFactory.eINSTANCE.createExpressionFilter()));
        newChildDescriptors.add(this.createChildParameter(SecurityPackage.Literals.FILTER_PERMISSION__FILTERS, SecurityFactory.eINSTANCE.createNotFilter()));
        newChildDescriptors.add(this.createChildParameter(SecurityPackage.Literals.FILTER_PERMISSION__FILTERS, SecurityFactory.eINSTANCE.createAndFilter()));
        newChildDescriptors.add(this.createChildParameter(SecurityPackage.Literals.FILTER_PERMISSION__FILTERS, SecurityFactory.eINSTANCE.createOrFilter()));
    }
}

