/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.importer.rose.builder;

import java.util.List;
import org.eclipse.emf.importer.rose.builder.RoseVisitor;
import org.eclipse.emf.importer.rose.parser.RoseNode;

public class RoseWalker {
    private RoseNode roseNode;
    private RoseVisitor visitor;

    public RoseWalker(RoseNode roseNode) {
        this.roseNode = roseNode;
    }

    public void traverse(RoseVisitor visitor) {
        this.visitor = visitor;
        this.traverseObject(this.roseNode);
    }

    private void traverseObject(RoseNode roseNode) {
        this.visitor.visitObject(roseNode);
        this.traverse(roseNode);
    }

    private void traverseList(RoseNode roseNode) {
        this.visitor.visitList(roseNode);
        this.traverse(roseNode);
    }

    private void traverse(RoseNode roseNode) {
        List<RoseNode> nodes = roseNode.getNodes();
        int i = 0;
        while (i < nodes.size()) {
            RoseNode node = nodes.get(i);
            if (node.getRoseNodeType() == 2) {
                this.traverseObject(node);
            } else if (node.getRoseNodeType() == 3) {
                this.traverseList(node);
            }
            ++i;
        }
    }
}

