/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.editor;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.graphiti.ui.editor.DiagramEditorInput;
import org.eclipse.graphiti.ui.internal.services.GraphitiUiInternal;
import org.eclipse.graphiti.ui.internal.util.ReflectionUtil;
import org.eclipse.ui.IEditorInput;

public class EditorInputAdapter {
    public static DiagramEditorInput adaptToDiagramEditorInput(IEditorInput otherInput) {
        if (otherInput instanceof DiagramEditorInput) {
            DiagramEditorInput input = (DiagramEditorInput)otherInput;
            return input;
        }
        IFile file = ReflectionUtil.getFile(otherInput);
        if (file != null) {
            URI diagramFileUri = GraphitiUiInternal.getEmfService().getFileURI(file);
            return EditorInputAdapter.createDiagramEditorInput(diagramFileUri);
        }
        if (otherInput instanceof URIEditorInput) {
            URIEditorInput uriInput = (URIEditorInput)otherInput;
            URI diagramFileUri = uriInput.getURI();
            return EditorInputAdapter.createDiagramEditorInput(diagramFileUri);
        }
        return null;
    }

    private static DiagramEditorInput createDiagramEditorInput(URI diagramFileUri) {
        if (diagramFileUri != null) {
            URI diagramUri = GraphitiUiInternal.getEmfService().mapDiagramFileUriToDiagramUri(diagramFileUri);
            return new DiagramEditorInput(diagramUri, null);
        }
        return null;
    }
}

