/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jpt.common.core.internal.utility.PlatformTools;
import org.eclipse.jpt.common.core.resource.xml.ERootObject;
import org.eclipse.jpt.common.core.resource.xml.JptXmlResource;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.ui.handlers.HandlerUtil;

public class UpgradeXmlResourceVersionHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object selectedObject = objectArray[n2];
            this.upgradeXmlResourceVersion(selectedObject);
            ++n2;
        }
        return null;
    }

    protected void upgradeXmlResourceVersion(Object selectedObject) {
        UpgradeXmlResourceVersionHandler.upgradeXmlResourceVersion(this.adaptSelection(selectedObject));
    }

    protected JptXmlResource adaptSelection(Object selectedObject) {
        return (JptXmlResource)PlatformTools.getAdapter((Object)selectedObject, JptXmlResource.class);
    }

    protected static void upgradeXmlResourceVersion(JptXmlResource xmlResource) {
        ERootObject root = xmlResource.getRootObject();
        IContentType contentType = xmlResource.getContentType();
        JpaProject jpaProject = UpgradeXmlResourceVersionHandler.getJpaProject(xmlResource);
        if (jpaProject != null) {
            String newVersion = jpaProject.getJpaPlatform().getMostRecentSupportedResourceType(contentType).getVersion();
            root.setDocumentVersion(newVersion);
            xmlResource.save();
        }
    }

    private static JpaProject getJpaProject(JptXmlResource xmlResource) {
        return (JpaProject)xmlResource.getFile().getProject().getAdapter(JpaProject.class);
    }
}

