/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.debug.ui.actions;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ocl.examples.debug.core.OCLDebugCore;
import org.eclipse.ocl.examples.debug.core.OCLLineBreakpoint;
import org.eclipse.ocl.examples.debug.ui.actions.OCLBreakpointLocationVerifier;
import org.eclipse.ocl.examples.debug.vm.core.VMLineBreakpoint;
import org.eclipse.ocl.examples.debug.vm.ui.actions.BreakpointLocationVerifier;
import org.eclipse.ocl.examples.debug.vm.ui.actions.VMToggleBreakpointAdapter;
import org.eclipse.ocl.examples.debug.vm.ui.messages.DebugVMUIMessages;
import org.eclipse.ocl.xtext.completeocl.ui.CompleteOCLEditor;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class CompleteOCLToggleBreakpointAdapter
extends VMToggleBreakpointAdapter {
    public boolean canToggleLineBreakpoints(IWorkbenchPart part, ISelection selection) {
        return part instanceof CompleteOCLEditor;
    }

    protected @NonNull BreakpointLocationVerifier createBreakpointLocationVerifier(@NonNull ITextEditor textEditor, @NonNull VMLineBreakpoint lineBreakpoint) {
        String invalidLocationMessage = DebugVMUIMessages.ToggleBreakpointAdapter_CannotSetBreakpoint;
        assert (invalidLocationMessage != null);
        return new OCLBreakpointLocationVerifier(textEditor, (ILineBreakpoint)lineBreakpoint, invalidLocationMessage);
    }

    protected @NonNull OCLLineBreakpoint createLineBreakpoint(int lineNumber, @NonNull URI sourceURI) throws CoreException {
        return new OCLLineBreakpoint(sourceURI, lineNumber);
    }

    protected @NonNull Object getBreakpointJobFamily() {
        return OCLLineBreakpoint.OCL_BREAKPOINT_JOBFAMILY;
    }

    protected @NonNull List<@NonNull ILineBreakpoint> getOCLBreakpoints() {
        return OCLDebugCore.INSTANCE.getOCLBreakpoints(ILineBreakpoint.class);
    }

    public void toggleLineBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        if (part instanceof CompleteOCLEditor) {
            super.toggleLineBreakpoints(part, selection);
        }
    }
}

