/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.wizards;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.php.internal.ui.wizards.IControlHandler;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public abstract class CompositeFragment
extends Composite {
    protected IControlHandler controlHandler;
    private boolean isComplete;
    private String name;
    private boolean isForEditing;
    private String title;
    private String description;
    private Object fragmentData;
    private ImageDescriptor imageDescriptor;

    public CompositeFragment(Composite parent, int style, IControlHandler handler, boolean isForEditing) {
        super(parent, style);
        this.controlHandler = handler;
        this.isForEditing = isForEditing;
        this.createControl();
    }

    public CompositeFragment(Composite parent, IControlHandler handler, boolean isForEditing) {
        this(parent, 0, handler, isForEditing);
    }

    public abstract boolean performOk();

    public abstract void validate();

    public void setData(Object fragmentData) {
        this.fragmentData = fragmentData;
    }

    public Object getData() {
        return this.fragmentData;
    }

    public void setDisplayName(String name) {
        this.name = name;
    }

    public String getDisplayName() {
        if (this.name == null) {
            this.name = "";
        }
        return this.name;
    }

    public void setImageDescriptor(ImageDescriptor descriptor) {
        this.imageDescriptor = descriptor;
    }

    public ImageDescriptor getImageDescriptor() {
        return this.imageDescriptor;
    }

    public String getTitle() {
        if (this.title == null) {
            this.title = "";
        }
        return this.title;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        if (this.description == null) {
            this.description = "";
        }
        return this.description;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean isForEditing() {
        return this.isForEditing;
    }

    public String getId() {
        return null;
    }

    public void performApply() {
        this.performOk();
    }

    public boolean performCancel() {
        return true;
    }

    public boolean isComplete() {
        return this.isComplete;
    }

    public void setMessage(String message, int type) {
        this.controlHandler.setMessage(message, type);
        this.setComplete(type != 3);
        this.controlHandler.update();
    }

    public void setComplete(boolean isComplete) {
        this.isComplete = isComplete;
        this.controlHandler.update();
    }

    protected abstract void createContents(Composite var1);

    protected void createControl() {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(4, 4, true, true));
        Composite composite = new Composite((Composite)this, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createContents(composite);
    }
}

