/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.routers;

import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.Bendpoint;
import org.eclipse.draw2d.BendpointConnectionRouter;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Translatable;

public class SiriusBendpointConnectionRouter
extends BendpointConnectionRouter {
    private static final PrecisionPoint A_POINT = new PrecisionPoint();

    public void route(Connection conn) {
        Point ref2;
        Point ref1;
        PointList points = conn.getPoints();
        points.removeAllPoints();
        List bendpoints = this.getConstraint(conn);
        if (bendpoints == null) {
            bendpoints = Collections.EMPTY_LIST;
        }
        if (bendpoints.isEmpty()) {
            ref1 = conn.getTargetAnchor().getReferencePoint();
            ref2 = conn.getSourceAnchor().getReferencePoint();
        } else if (bendpoints.size() >= 3) {
            ref1 = new Point(((Bendpoint)bendpoints.get(1)).getLocation());
            conn.translateToAbsolute((Translatable)ref1);
            ref2 = new Point(((Bendpoint)bendpoints.get(bendpoints.size() - 2)).getLocation());
            conn.translateToAbsolute((Translatable)ref2);
        } else {
            ref1 = new Point(((Bendpoint)bendpoints.get(0)).getLocation());
            conn.translateToAbsolute((Translatable)ref1);
            ref2 = new Point(((Bendpoint)bendpoints.get(bendpoints.size() - 1)).getLocation());
            conn.translateToAbsolute((Translatable)ref2);
        }
        A_POINT.setLocation(conn.getSourceAnchor().getLocation(ref1));
        conn.translateToRelative((Translatable)A_POINT);
        points.addPoint((Point)A_POINT);
        if (bendpoints.size() > 2) {
            int i = 1;
            while (i < bendpoints.size() - 1) {
                Bendpoint bp = (Bendpoint)bendpoints.get(i);
                points.addPoint(bp.getLocation());
                ++i;
            }
        }
        A_POINT.setLocation(conn.getTargetAnchor().getLocation(ref2));
        conn.translateToRelative((Translatable)A_POINT);
        points.addPoint((Point)A_POINT);
        conn.setPoints(points);
    }
}

