/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.refresh;

import com.google.common.base.Predicate;
import java.util.Collection;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.session.ModelChangeTrigger;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.internal.session.SessionEventBrokerImpl;
import org.eclipse.sirius.diagram.business.internal.refresh.DSemanticDiagramScopePredicate;
import org.eclipse.sirius.diagram.business.internal.refresh.SiriusGMFSynchronizerDispatcher;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.tools.api.SiriusPlugin;

public final class SiriusDiagramSessionEventBroker
implements ModelChangeTrigger {
    public static final int PRIORITY = 4;
    private static final Map<Session, SiriusDiagramSessionEventBroker> INSTANCES_MAP = new WeakHashMap<Session, SiriusDiagramSessionEventBroker>();
    private static Predicate<Notification> scope = new DSemanticDiagramScopePredicate();
    private static SiriusGMFSynchronizerDispatcher viewpointGMFSynchronizerDispatcher = new SiriusGMFSynchronizerDispatcher();

    private SiriusDiagramSessionEventBroker() {
    }

    public static SiriusDiagramSessionEventBroker getInstance(Session session) {
        return SiriusDiagramSessionEventBroker.initializeDiagramEventBroker(session);
    }

    private static SiriusDiagramSessionEventBroker initializeDiagramEventBroker(Session session) {
        SiriusDiagramSessionEventBroker reference = INSTANCES_MAP.get(session);
        if (reference == null) {
            SiriusDiagramSessionEventBroker viewpointDiagramSessionEventBroker = new SiriusDiagramSessionEventBroker();
            session.getEventBroker().addLocalTrigger(SessionEventBrokerImpl.asFilter(scope), (ModelChangeTrigger)viewpointDiagramSessionEventBroker);
            reference = viewpointDiagramSessionEventBroker;
            INSTANCES_MAP.put(session, reference);
        }
        return reference;
    }

    public Option<Command> localChangesAboutToCommit(Collection<Notification> notifications) {
        if (!SiriusPlugin.getDefault().isRepairInProgress()) {
            TransactionalEditingDomain domain = this.getSession().getTransactionalEditingDomain();
            Option triggerCommand = Options.newSome((Object)viewpointGMFSynchronizerDispatcher.getGMFNotationModelSynchronizationCmd(domain, notifications));
            return triggerCommand;
        }
        return Options.newNone();
    }

    private Session getSession() {
        Session session = null;
        for (Map.Entry<Session, SiriusDiagramSessionEventBroker> entry : INSTANCES_MAP.entrySet()) {
            if (!this.equals(entry.getValue())) continue;
            session = entry.getKey();
            break;
        }
        return session;
    }

    public int priority() {
        return 4;
    }
}

