/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.snippets.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.LineStyleEvent;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.common.snippets.core.ISnippetItem;
import org.eclipse.wst.common.snippets.core.ISnippetVariable;
import org.eclipse.wst.common.snippets.internal.SnippetsMessages;
import org.eclipse.wst.common.snippets.internal.SnippetsPlugin;
import org.eclipse.wst.common.snippets.internal.palette.SnippetVariable;
import org.eclipse.wst.common.snippets.internal.ui.StringPropertyTableViewer;
import org.eclipse.wst.common.snippets.internal.ui.ValueChangedListener;
import org.eclipse.wst.common.snippets.internal.util.StringUtils;

public class VariableInsertionDialog
extends Dialog {
    private List<DisposeListener> disposeListeners = new ArrayList<DisposeListener>();
    protected StyledText fDescriptionPane = null;
    protected ISnippetItem fItem = null;
    protected String fPreparedText = null;
    protected StyledText fPreviewPane = null;
    protected StringPropertyTableViewer fTableViewer = null;

    public VariableInsertionDialog(Shell parentShell, boolean clearModality) {
        super(parentShell);
        if (clearModality) {
            this.setShellStyle(2160);
        } else {
            this.setShellStyle(0x10 | this.getShellStyle());
        }
    }

    protected void addContents(Composite composite) {
    }

    public void addDisposeListener(DisposeListener listener) {
        if (!this.disposeListeners.contains(listener)) {
            this.disposeListeners.add(listener);
        }
    }

    public void create() {
        super.create();
        int i = 0;
        while (i < this.disposeListeners.size()) {
            this.getShell().addDisposeListener(this.disposeListeners.get(i));
            ++i;
        }
        this.getShell().setActive();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setText(SnippetsMessages.Insert_14);
    }

    protected Control createDialogArea(Composite parent) {
        parent.getShell().setText(this.getDialogTitle());
        SnippetsPlugin.getDefault().getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.wst.common.snippets.libv1100");
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        layout.horizontalSpacing += 2;
        layout.verticalSpacing += 2;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parent.getFont());
        GridData doubleWide = new GridData(1808);
        doubleWide.horizontalSpan = 2;
        Text instructions = new Text(composite, 16448);
        instructions.setBackground(composite.getBackground());
        doubleWide.heightHint = instructions.getFont().getFontData()[0].getHeight() * 3;
        instructions.setLayoutData((Object)doubleWide);
        instructions.setText(SnippetsMessages.Edit_Instruction);
        instructions.setEditable(false);
        Text tableLabel = new Text(composite, 0);
        tableLabel.setBackground(composite.getBackground());
        tableLabel.setText(SnippetsMessages.Variables__4);
        tableLabel.setLayoutData((Object)new GridData(768));
        tableLabel.setEditable(false);
        Text descriptionBoxLabel = new Text(composite, 0);
        descriptionBoxLabel.setBackground(composite.getBackground());
        descriptionBoxLabel.setText(SnippetsMessages.Description_of_variable__5);
        descriptionBoxLabel.setLayoutData((Object)new GridData(768));
        descriptionBoxLabel.setEditable(false);
        this.fTableViewer = new StringPropertyTableViewer();
        this.fTableViewer.setColumnNames(new String[]{SnippetsMessages.Variable_Name_6, SnippetsMessages.Value_7});
        this.fTableViewer.setEditFirstColumn(false);
        this.fTableViewer.createContents(composite);
        GridData data = new GridData(1808);
        data.heightHint = this.fTableViewer.getTable().getItemHeight() * 5;
        this.fTableViewer.getControl().setLayoutData((Object)data);
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISnippetVariable variable = null;
                if (VariableInsertionDialog.this.fTableViewer.getSelection() != null) {
                    variable = VariableInsertionDialog.this.getVariable(VariableInsertionDialog.this.fTableViewer.getSelection());
                }
                VariableInsertionDialog.this.fDescriptionPane.setText(variable != null ? variable.getDescription() : "");
                VariableInsertionDialog.this.fDescriptionPane.setHorizontalPixel(2);
                VariableInsertionDialog.this.fDescriptionPane.redraw();
            }
        });
        this.fTableViewer.addValueChangedListener(new ValueChangedListener(){

            @Override
            public void valueChanged(String key, String property, String oldValue, String newValue) {
                VariableInsertionDialog.this.update();
            }
        });
        this.fDescriptionPane = new StyledText(composite, 2888);
        this.fDescriptionPane.setLayoutData((Object)new GridData(1808));
        this.fDescriptionPane.setEnabled(true);
        this.fDescriptionPane.setEditable(false);
        this.fDescriptionPane.addVerifyKeyListener(VariableInsertionDialog.createVerifyListener((Control)this.fDescriptionPane));
        this.fDescriptionPane.setFont(JFaceResources.getDialogFont());
        VariableInsertionDialog.setAccessible((Control)this.fDescriptionPane, SnippetsMessages.Description_of_variable__5);
        doubleWide = new GridData(1808);
        doubleWide.horizontalSpan = 2;
        Text previewLabel = new Text(composite, 0);
        previewLabel.setBackground(composite.getBackground());
        previewLabel.setText(SnippetsMessages.Preview__9);
        previewLabel.setEditable(false);
        doubleWide = new GridData(1808);
        doubleWide.horizontalSpan = 2;
        doubleWide.heightHint = parent.getDisplay().getClientArea().height / 6;
        doubleWide.widthHint = parent.getDisplay().getClientArea().width / 8;
        this.fPreviewPane = new StyledText(composite, 2824);
        this.fPreviewPane.addVerifyKeyListener(VariableInsertionDialog.createVerifyListener((Control)this.fPreviewPane));
        this.fPreviewPane.addLineStyleListener(new LineStyleListener(){

            public void lineGetStyle(LineStyleEvent event) {
            }
        });
        this.fPreviewPane.setEnabled(true);
        this.fPreviewPane.setEditable(false);
        this.fPreviewPane.setFont(JFaceResources.getTextFont());
        this.fPreviewPane.setLayoutData((Object)doubleWide);
        VariableInsertionDialog.setAccessible((Control)this.fPreviewPane, SnippetsMessages.Preview__9);
        if (this.fItem != null) {
            this.fTableViewer.clear();
            this.populateTableViewer();
            this.fTableViewer.refresh();
        }
        this.addContents(composite);
        this.update();
        this.fTableViewer.getControl().setFocus();
        return composite;
    }

    static VerifyKeyListener createVerifyListener(Control control) {
        final Control widget = control;
        return new VerifyKeyListener(){

            public void verifyKey(VerifyEvent event) {
                if (event.character == '\t') {
                    if ((event.stateMask & 0x20000) != 0) {
                        widget.traverse(8);
                    } else {
                        widget.traverse(16);
                    }
                }
            }
        };
    }

    protected String getDialogTitle() {
        Object shellLabel = "";
        String itemLabel = this.getItem().getLabel();
        shellLabel = itemLabel != null && itemLabel.length() > 0 ? SnippetsMessages.Insert_Template___1 + " " + itemLabel : SnippetsMessages.Insert_Template_2;
        return shellLabel;
    }

    public ISnippetItem getItem() {
        return this.fItem;
    }

    public String getPreparedText() {
        if (this.fPreparedText == null) {
            this.prepareText();
        }
        return this.fPreparedText;
    }

    protected ISnippetVariable getVariable(String id) {
        if (this.fItem == null) {
            return null;
        }
        ISnippetVariable[] variables = this.fItem.getVariables();
        int i = 0;
        while (i < variables.length) {
            if (((SnippetVariable)variables[i]).getId().equals(id)) {
                return variables[i];
            }
            ++i;
        }
        return null;
    }

    protected void okPressed() {
        this.fTableViewer.finishEditing();
        super.okPressed();
        this.prepareText();
    }

    protected void populateTableViewer() {
        ISnippetVariable[] variables = this.fItem.getVariables();
        int i = 0;
        while (i < variables.length) {
            this.fTableViewer.getColumnData()[0].put(((SnippetVariable)variables[i]).getId(), ((SnippetVariable)variables[i]).getName());
            this.fTableViewer.getColumnData()[1].put(((SnippetVariable)variables[i]).getId(), ((SnippetVariable)variables[i]).getDefaultValue());
            ++i;
        }
    }

    protected void prepareText() {
        String text = this.fItem.getContentString();
        ISnippetVariable[] variables = this.fItem.getVariables();
        int i = 0;
        while (i < variables.length) {
            String value = (String)this.fTableViewer.getColumnData()[1].get(((SnippetVariable)variables[i]).getId());
            text = StringUtils.replace(text, "${" + variables[i].getName() + "}", value);
            ++i;
        }
        text = StringUtils.replace(text, "${cursor}", "");
        String systemEOL = System.getProperty("line.separator");
        text = StringUtils.replace(text, "\r\n", "\n");
        text = StringUtils.replace(text, "\r", "\n");
        if (!"\n".equals(systemEOL) && systemEOL != null) {
            text = StringUtils.replace(text, "\n", systemEOL);
        }
        this.setPreparedText(text);
    }

    public void removeDisposeListener(DisposeListener listener) {
        this.disposeListeners.remove(listener);
    }

    static void setAccessible(Control control, String name) {
        if (control == null) {
            return;
        }
        final String n = name;
        control.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (e.childID == -1) {
                    e.result = n;
                }
            }
        });
    }

    public void setItem(ISnippetItem item) {
        this.fItem = item;
        if (this.fTableViewer != null) {
            this.fTableViewer.clear();
            this.populateTableViewer();
        }
    }

    protected void setPreparedText(String preparedText) {
        this.fPreparedText = preparedText;
    }

    protected void update() {
        this.prepareText();
        if (this.fPreviewPane != null && !this.fPreviewPane.isDisposed()) {
            this.fPreviewPane.setText(this.getPreparedText());
            this.fPreviewPane.setHorizontalPixel(2);
            this.fPreviewPane.redraw();
        }
    }
}

