/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.monitor;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.wst.wsi.internal.core.ToolInfo;
import org.eclipse.wst.wsi.internal.core.WSIConstants;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.WSIFileNotFoundException;
import org.eclipse.wst.wsi.internal.core.document.DocumentFactory;
import org.eclipse.wst.wsi.internal.core.log.Log;
import org.eclipse.wst.wsi.internal.core.log.LogWriter;
import org.eclipse.wst.wsi.internal.core.monitor.MessageEntryQueue;
import org.eclipse.wst.wsi.internal.core.monitor.ServerSocketListener;
import org.eclipse.wst.wsi.internal.core.monitor.config.ManInTheMiddle;
import org.eclipse.wst.wsi.internal.core.monitor.config.MonitorConfig;
import org.eclipse.wst.wsi.internal.core.monitor.config.Redirect;
import org.eclipse.wst.wsi.internal.core.util.MessageList;
import org.eclipse.wst.wsi.internal.core.util.TestUtils;

public class Monitor {
    protected MessageList messageList = null;
    private static final String RESOURCE_BUNDLE_NAME = "org.eclipse.wst.wsi.internal.core.monitor.Monitor";
    public static final String USAGE_MESSAGE = "Usage: Monitor -config <configFilename>";
    private int conversationId = 1;
    private Log log = null;
    private LogWriter logWriter = null;
    private MonitorConfig monitorConfig = null;
    public static final String TOOL_NAME = "Monitor";
    protected ToolInfo toolInfo = null;
    protected Vector listenerList = new Vector();
    protected MessageEntryQueue messageEntryQueue = null;

    public Monitor(String[] args) throws WSIException {
        this.messageList = new MessageList(RESOURCE_BUNDLE_NAME);
        this.toolInfo = new ToolInfo(TOOL_NAME);
        DocumentFactory documentFactory = DocumentFactory.newInstance();
        this.monitorConfig = documentFactory.newMonitorConfig();
        this.monitorConfig.init(this.messageList);
        this.monitorConfig.parseArgs(args);
        String logLocation = this.monitorConfig.getLogLocation();
        if (logLocation.indexOf(WSIConstants.PATH_SEPARATOR) > -1) {
            throw new WSIException(this.messageList.getMessage("config11", this.monitorConfig.getLogLocation(), "The log file location value cannot contain the pass separator character:"));
        }
        File file = null;
        try {
            file = new File(this.monitorConfig.getLogLocation());
        }
        catch (Exception e) {
            throw new WSIException(this.messageList.getMessage("config07", "Could not get log file location."), e);
        }
        if (file.exists() && !this.monitorConfig.getReplaceLog()) {
            throw new IllegalArgumentException(this.messageList.getMessage("config08", this.monitorConfig.getLogLocation(), "Log file already exists:"));
        }
        try {
            this.log = documentFactory.newLog();
            this.log.setStyleSheetString(this.monitorConfig.getAddStyleSheet().getStyleSheetString());
            this.logWriter = documentFactory.newLogWriter();
            this.logWriter.setWriter(this.monitorConfig.getLogLocation());
            this.logWriter.write(new StringReader(this.log.getStartXMLString("")));
            this.logWriter.write(new StringReader(this.toXMLString("")));
            this.messageEntryQueue = new MessageEntryQueue(this, this.log, this.logWriter);
        }
        catch (Exception e) {
            throw new WSIException(this.messageList.getMessage("error03", "Could not create log or log writer."), e);
        }
        ManInTheMiddle manInTheMiddle = this.monitorConfig.getManInTheMiddle();
        for (Redirect redirect : manInTheMiddle.getRedirectList()) {
            this.listenerList.add(new ServerSocketListener(this, redirect));
        }
        Runtime.getRuntime().addShutdownHook(new ShutdownHook());
        Console console = new Console();
        console.start();
    }

    public MonitorConfig getMonitorConfig() {
        return this.monitorConfig;
    }

    public Log getLog() {
        return this.log;
    }

    public MessageEntryQueue getMessageEntryQueue() {
        return this.messageEntryQueue;
    }

    void exitMonitor() {
        this.printMessage("stopping01", "Stopping the monitor...");
        System.exit(0);
    }

    void exitMonitor(Exception e) {
        this.printMessage("stopping02", "Stopping monitor because an exception occurred.");
        System.err.println("EXCEPTION: " + e.toString());
        if (this.monitorConfig.getVerboseOption()) {
            e.printStackTrace();
        }
        this.exitMonitor();
    }

    void stopMonitor() {
        try {
            Iterator iterator = this.listenerList.iterator();
            while (iterator.hasNext()) {
                ((ServerSocketListener)iterator.next()).shutdown();
            }
            Thread.sleep(this.monitorConfig.getTimeout() * 1000);
            if (this.logWriter != null) {
                this.logWriter.write(new StringReader(this.log.getEndXMLString("")));
                this.logWriter.close();
            }
        }
        catch (Exception exception) {}
        this.printMessage("stopped01", "Monitor stopped.");
    }

    public static void main(String[] args) {
        Monitor monitor = null;
        try {
            if (args.length < 2) {
                Monitor.staticPrintMessage("usage01", USAGE_MESSAGE);
                System.exit(1);
            }
            if (!args[0].equalsIgnoreCase("-config")) {
                Monitor.staticPrintMessage("usage01", USAGE_MESSAGE);
                System.exit(1);
            }
            monitor = new Monitor(args);
        }
        catch (Exception e) {
            String messageData;
            String defaultMessage;
            String messageID;
            boolean printStackTrace = true;
            if (e instanceof WSIFileNotFoundException || e instanceof IllegalArgumentException) {
                printStackTrace = false;
                messageID = "error01";
                defaultMessage = "Monitor Error:";
                messageData = e.getMessage();
            } else {
                printStackTrace = true;
                messageID = "error02";
                defaultMessage = "Monitor Stopped By Exception:";
                messageData = e.toString();
            }
            if (monitor != null) {
                monitor.printMessage(messageID, messageData, defaultMessage);
            } else {
                Monitor.staticPrintMessage(messageID, messageData, defaultMessage);
            }
            if (printStackTrace) {
                e.printStackTrace();
            }
            if (monitor != null) {
                monitor.exitMonitor();
            }
            System.exit(2);
        }
    }

    public void printMessage(String key, String defaultMessage) {
        this.printMessage(key, null, defaultMessage);
    }

    public void printMessage(String key, String messageData, String defaultMessage) {
        this.messageList.printMessage(key, messageData, defaultMessage);
    }

    public static void staticPrintMessage(String key, String defaultMessage) {
        Monitor.staticPrintMessage(key, null, defaultMessage);
    }

    public static void staticPrintMessage(String key, String messageData, String defaultMessage) {
        MessageList.printMessage(RESOURCE_BUNDLE_NAME, key, messageData, defaultMessage);
    }

    synchronized int getNextConversationId() {
        return this.conversationId++;
    }

    public String toXMLString(String namespaceName) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.print(this.toolInfo.getStartXMLString(namespaceName));
        pw.print(this.monitorConfig.toXMLString("wsi-monConfig"));
        pw.println(this.toolInfo.getEndXMLString(namespaceName));
        return sw.toString();
    }

    class Console
    extends Thread {
        Console() {
        }

        @Override
        public void run() {
            String exitString = Monitor.this.messageList.getMessage("exit01", "exit");
            TestUtils.printToolInfo(Monitor.this.toolInfo);
            System.out.print(Monitor.this.monitorConfig.toString());
            System.out.println(" ");
            Monitor.this.printMessage("start01", "The " + Monitor.this.toolInfo.getName() + " tool is ready to intercept and log web service messages.");
            Monitor.this.printMessage("start02", "Type \"exit\" to stop the " + Monitor.this.toolInfo.getName() + ".");
            System.out.println(" ");
            long stopTime = System.currentTimeMillis() + (long)(Monitor.this.monitorConfig.getLogDuration() * 1000);
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
                boolean exit = false;
                while (!exit && System.currentTimeMillis() < stopTime) {
                    Thread.sleep(500L);
                    if (!reader.ready() || !reader.readLine().equalsIgnoreCase(exitString)) continue;
                    exit = true;
                }
            }
            catch (Exception e) {
                System.err.println(e.toString());
            }
            Monitor.this.exitMonitor();
        }
    }

    class ShutdownHook
    extends Thread {
        ShutdownHook() {
        }

        @Override
        public void run() {
            Monitor.this.stopMonitor();
        }
    }
}

