/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.shared.internal;

import com.google.common.collect.Lists;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.util.Modules;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.swt.widgets.Display;
import org.eclipse.xtext.XtextRuntimeModule;
import org.eclipse.xtext.common.types.ui.notification.TypeResourceUnloader;
import org.eclipse.xtext.ide.DefaultIdeModule;
import org.eclipse.xtext.ui.DefaultUiModule;
import org.eclipse.xtext.ui.shared.internal.EagerContributionInitializer;
import org.eclipse.xtext.ui.shared.internal.SharedModule;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.Version;

public class Activator
extends Plugin {
    private static final String PLUGIN_ID_JDT_UI = "org.eclipse.jdt.ui";
    private static final String PLUGIN_ID_XTEXT_RT = "org.eclipse.xtext";
    private static final String PLUGIN_ID_XTEXT_UI = "org.eclipse.xtext.ui";
    private static final String PLUGIN_ID_XTEND_RT = "org.eclipse.xtend";
    private static final Logger log = Logger.getLogger(Activator.class);
    private static Activator plugin;
    public static final String PLUGIN_ID = "org.eclipse.xtext.ui.shared";
    private Injector injector;
    @Inject
    private EagerContributionInitializer initializer;

    public static Activator getDefault() {
        return plugin;
    }

    public Injector getInjector() {
        return this.injector;
    }

    protected void initializeInjector(BundleContext context) throws CoreException {
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.xtext.ui.shared.overridingGuiceModule");
        IExtension[] extensions = point.getExtensions();
        SharedModule module = new SharedModule(context);
        if (extensions.length != 0) {
            int numberOfMixedInModules = 0;
            StringBuilder sb = new StringBuilder("Multiple contributions to extension point 'org.eclipse.xtext.ui.shared.overridingGuiceModule'. Will use them in unspecified order.");
            IExtension[] iExtensionArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] elements;
                IExtension iExtension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = elements = iExtension.getConfigurationElements();
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement e = iConfigurationElementArray[n4];
                    try {
                        Module m = (Module)e.createExecutableExtension("class");
                        module = Modules.override((Module[])new Module[]{module}).with(new Module[]{m});
                        ++numberOfMixedInModules;
                        sb.append("\n\tcontributor: ").append(e.getContributor().getName());
                    }
                    catch (CoreException e1) {
                        log.error((Object)e1.getMessage(), (Throwable)e1);
                    }
                    ++n4;
                }
                ++n2;
            }
            if (numberOfMixedInModules >= 2) {
                log.warn((Object)sb.toString());
            }
        }
        try {
            this.injector = Guice.createInjector((Module[])new Module[]{module});
            this.injector.createChildInjector(new Module[]{new Module(){

                public void configure(Binder binder) {
                    binder.bind(EagerContributionInitializer.class);
                }
            }}).injectMembers((Object)this);
        }
        catch (Throwable t) {
            this.handleGuiceInitializationError(t);
        }
    }

    protected void handleGuiceInitializationError(Throwable t) throws CoreException {
        Bundle bundleXtextRuntime = FrameworkUtil.getBundle(XtextRuntimeModule.class);
        Bundle bundleXtextIde = FrameworkUtil.getBundle(DefaultIdeModule.class);
        Bundle bundleXtextUi = FrameworkUtil.getBundle(DefaultUiModule.class);
        Bundle bundleXtextUiShared = FrameworkUtil.getBundle(SharedModule.class);
        StringBuilder msg = new StringBuilder();
        msg.append("Xtext configuration error!\n");
        msg.append("This error might indicate missing version constraints of installed Xtext based bundles.\n");
        msg.append("The following bundles were detected that require Xtext UI:\n");
        this.getBundlesRequiringXtextUi().forEach(bundle -> {
            StringBuilder stringBuilder2 = msg.append("- " + this.getBundleInfo((Bundle)bundle) + "\n");
        });
        msg.append("The installed Xtext bundle versions are:\n");
        Lists.newArrayList((Object[])new Bundle[]{bundleXtextRuntime, bundleXtextIde, bundleXtextUi, bundleXtextUiShared}).forEach(bundle -> {
            StringBuilder stringBuilder2 = msg.append("- " + this.getBundleInfo((Bundle)bundle) + "\n");
        });
        if (this.compareVersionIgnoringQualifier(bundleXtextRuntime.getVersion(), bundleXtextUiShared.getVersion()) > 0) {
            msg.append("Runtime bundle is NEWER than UI bundles! Please make sure that both bundles are installed with the same version!\n");
        }
        throw new CoreException((IStatus)new Status(4, this.getBundle().getSymbolicName(), msg.toString(), t));
    }

    private int compareVersionIgnoringQualifier(Version v1, Version v2) {
        return new Version(v1.getMajor(), v1.getMinor(), v1.getMicro()).compareTo(new Version(v2.getMajor(), v2.getMinor(), v2.getMicro()));
    }

    private String getBundleInfo(Bundle bundle) {
        String state = null;
        switch (bundle.getState()) {
            case 1: {
                state = "UNINSTALLED";
                break;
            }
            case 2: {
                state = "INSTALLED";
                break;
            }
            case 4: {
                state = "RESOLVED";
                break;
            }
            case 8: {
                state = "STARTING";
                break;
            }
            case 16: {
                state = "STOPPING";
                break;
            }
            case 32: {
                state = "ACTIVE";
            }
        }
        return bundle.getSymbolicName() + " " + String.valueOf(bundle.getVersion()) + " [" + state + "]";
    }

    public List<Bundle> getBundlesRequiringXtextUi() {
        return Arrays.asList(this.getBundle().getBundleContext().getBundles()).stream().filter(bundle -> !Arrays.stream(new String[]{PLUGIN_ID_XTEXT_RT, PLUGIN_ID_XTEND_RT}).anyMatch(s -> bundle.getSymbolicName().startsWith((String)s))).filter(bundle -> {
            ManifestElement[] requireBundle;
            block3: {
                try {
                    requireBundle = ManifestElement.parseHeader((String)"Require-Bundle", (String)((String)bundle.getHeaders().get("Require-Bundle")));
                    if (requireBundle != null) break block3;
                    return false;
                }
                catch (BundleException bundleException) {
                    return false;
                }
            }
            Stream<ManifestElement> requireElements = Arrays.stream(requireBundle);
            return requireElements.map(e -> e.getValueComponents()).flatMap(e -> Arrays.stream(e)).anyMatch(bundleName -> PLUGIN_ID_XTEXT_UI.equals(bundleName));
        }).collect(Collectors.toList());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isJavaEnabled() {
        try {
            Bundle[] bundles;
            JavaCore.class.getName();
            TypeResourceUnloader.class.getName();
            if (Display.getCurrent() != null) {
                JavaUI.class.getName();
                return true;
            }
            Bundle[] bundleArray = bundles = plugin.getBundle().getBundleContext().getBundles();
            int n = bundles.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                Bundle bundle = bundleArray[n2];
                if (PLUGIN_ID_JDT_UI.equals(bundle.getSymbolicName())) {
                    return true;
                }
                ++n2;
            }
        }
        catch (Throwable e) {
            log.info((Object)("Disabling JDT use. : " + e.getMessage()));
            log.debug((Object)e.getMessage(), e);
            return false;
        }
    }

    public void start(BundleContext context) throws Exception {
        try {
            super.start(context);
            plugin = this;
            this.initializeInjector(context);
            this.initializer.initialize();
        }
        catch (CoreException e) {
            throw e;
        }
        catch (Exception e) {
            log.error((Object)("Error initializing org.eclipse.xtext.ui.shared:" + e.getMessage()), (Throwable)e);
        }
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        this.injector = null;
        if (this.initializer != null) {
            this.initializer.discard();
            this.initializer = null;
        }
        super.stop(context);
    }
}

