/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.imports;

import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.refactoring.impl.DefaultRefactoringDocumentProvider;
import org.eclipse.xtext.ui.refactoring.impl.EditorDocumentChange;
import org.eclipse.xtext.ui.refactoring.impl.IRefactoringDocument;
import org.eclipse.xtext.ui.refactoring.impl.StatusWrapper;
import org.eclipse.xtext.ui.resource.IStorage2UriMapper;
import org.eclipse.xtext.ui.resource.XtextLiveScopeResourceSetProvider;
import org.eclipse.xtext.xbase.imports.ImportOrganizer;
import org.eclipse.xtext.xbase.ui.imports.Messages;
import org.eclipse.xtext.xbase.ui.imports.ReplaceConverter;

@Singleton
public class MultiImportOrganizer {
    @Inject
    private IRefactoringDocument.Provider provider;
    @Inject
    private ImportOrganizer importOrganizer;
    @Inject
    private IStorage2UriMapper storageMapper;
    @Inject
    private ReplaceConverter replaceConverter;
    @Inject
    private StatusWrapper status;
    @Inject
    private XtextLiveScopeResourceSetProvider resSetProvider;

    public List<Change> organizeImports(Multimap<IProject, IFile> files, IProgressMonitor mon) throws InterruptedException {
        ArrayList result = Lists.newArrayList();
        for (IProject project : files.keySet()) {
            ResourceSet resSet = this.resSetProvider.get(project);
            for (IFile file : files.get((Object)project)) {
                mon.subTask("Calculating imports in - " + file.getName());
                URI uri = this.storageMapper.getUri((IStorage)file);
                if (uri != null) {
                    XtextResource resource = (XtextResource)resSet.getResource(uri, true);
                    List replace = this.importOrganizer.getOrganizedImportChanges(resource);
                    if (replace == null || replace.isEmpty()) continue;
                    TextEdit textEdit = this.replaceConverter.convertToTextEdit(replace);
                    IRefactoringDocument iRefactoringDocument = this.provider.get(uri, this.status);
                    if (iRefactoringDocument != null) {
                        Change change = iRefactoringDocument.createChange(Messages.OrganizeImports, textEdit);
                        if (change instanceof EditorDocumentChange && ((DefaultRefactoringDocumentProvider.EditorDocument)iRefactoringDocument).getEditor().isDirty()) {
                            ((EditorDocumentChange)change).setDoSave(false);
                        }
                        result.add(change);
                    }
                }
                mon.worked(1);
                if (!mon.isCanceled()) continue;
                throw new InterruptedException();
            }
        }
        return result;
    }
}

