/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl;

import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import org.apache.felix.scr.impl.logger.InternalLogger;
import org.apache.felix.scr.impl.logger.ScrLogger;

class ComponentActorExecutor
extends ScheduledThreadPoolExecutor {
    private static final ThreadFactory THREAD_FACTORY = new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, "SCR Component Actor");
            thread.setDaemon(true);
            return thread;
        }
    };
    private final ScrLogger logger;

    ComponentActorExecutor(ScrLogger log) {
        super(1, THREAD_FACTORY);
        this.logger = log;
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        this.logger.log(InternalLogger.Level.DEBUG, "Running task: " + r, null);
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        if (t != null) {
            this.logger.log(InternalLogger.Level.ERROR, "Unexpected problem executing task " + r, t);
        }
    }
}

