/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.runtime.impl.completion;

import org.eclipse.acceleo.query.parser.AstBuilder;
import org.eclipse.acceleo.query.runtime.ICompletionProposal;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class EClassifierCompletionProposal
implements ICompletionProposal {
    private final EClassifier eClassifier;

    public EClassifierCompletionProposal(EClassifier eClassifier) {
        this.eClassifier = eClassifier;
    }

    @Override
    public String getProposal() {
        String packageName = AstBuilder.protectWithUnderscore(this.eClassifier.getEPackage().getName());
        String classifierName = AstBuilder.protectWithUnderscore(this.eClassifier.getName());
        return packageName + "::" + classifierName;
    }

    @Override
    public int getCursorOffset() {
        return this.getProposal().length();
    }

    public EClassifier getObject() {
        return this.eClassifier;
    }

    public String toString() {
        return this.getProposal();
    }

    @Override
    public String getDescription() {
        StringBuffer result = new StringBuffer();
        result.append(this.eClassifier.eClass().getName());
        result.append(" named ");
        result.append(this.eClassifier.getName());
        result.append(" in ");
        result.append(this.eClassifier.getEPackage().getNsPrefix());
        result.append('(');
        result.append(this.eClassifier.getEPackage().getNsURI());
        result.append(')');
        String doc = EcoreUtil.getDocumentation((EModelElement)this.eClassifier);
        if (doc != null) {
            result.append('\n');
            result.append(doc);
        }
        return result.toString();
    }
}

