/*
 * Decompiled with CFR 0.152.
 */
package lpg.lpgjavaruntime;

import lpg.lpgjavaruntime.Monitor;
import lpg.lpgjavaruntime.ParseTable;
import lpg.lpgjavaruntime.RuleAction;
import lpg.lpgjavaruntime.TokenStream;

public class LexParser {
    private int START_STATE;
    private int LA_STATE_OFFSET;
    private int EOFT_SYMBOL;
    private int ACCEPT_ACTION;
    private int ERROR_ACTION;
    private TokenStream tokStream;
    private ParseTable prs;
    private RuleAction ra;
    private int STACK_INCREMENT = 1024;
    private int stateStackTop;
    private int stackLength = 0;
    private int[] stack;
    private int[] locationStack;
    private int ptraStackTop = -1;
    private ParseTable[] parseTableStack = new ParseTable[this.STACK_INCREMENT];
    private RuleAction[] ruleActionStack = new RuleAction[this.STACK_INCREMENT];
    private int lastToken;
    private int currentAction;
    private int curtok;
    private int starttok;
    private int current_kind;

    public LexParser() {
    }

    public LexParser(TokenStream tokStream, ParseTable prs, RuleAction ra) {
        this.tokStream = tokStream;
        this.pushPtRa(prs, ra);
    }

    private void initialize(ParseTable prs, RuleAction ra) {
        this.prs = prs;
        this.ra = ra;
        this.START_STATE = prs.getStartState();
        this.LA_STATE_OFFSET = prs.getLaStateOffset();
        this.EOFT_SYMBOL = prs.getEoftSymbol();
        this.ACCEPT_ACTION = prs.getAcceptAction();
        this.ERROR_ACTION = prs.getErrorAction();
    }

    public void pushPtRa(ParseTable prs, RuleAction ra) {
        ++this.ptraStackTop;
        this.parseTableStack[this.ptraStackTop] = prs;
        this.ruleActionStack[this.ptraStackTop] = ra;
        this.initialize(prs, ra);
    }

    public void popPtRa() {
        --this.ptraStackTop;
        ParseTable prs = this.parseTableStack[this.ptraStackTop];
        RuleAction ra = this.ruleActionStack[this.ptraStackTop];
        this.initialize(prs, ra);
    }

    private void reallocateStacks() {
        int old_stack_length = this.stack == null ? 0 : this.stackLength;
        this.stackLength += this.STACK_INCREMENT;
        if (old_stack_length == 0) {
            this.stack = new int[this.stackLength];
            this.locationStack = new int[this.stackLength];
        } else {
            this.stack = new int[this.stackLength];
            System.arraycopy(this.stack, 0, this.stack, 0, old_stack_length);
            this.locationStack = new int[this.stackLength];
            System.arraycopy(this.locationStack, 0, this.locationStack, 0, old_stack_length);
        }
    }

    public final int getToken(int i) {
        return this.locationStack[this.stateStackTop + (i - 1)];
    }

    public final void setSym1(int i) {
    }

    public final int getSym(int i) {
        return this.getLastToken(i);
    }

    public final int getCurrentRule() {
        return this.currentAction;
    }

    public final int getFirstToken() {
        return this.getToken(1);
    }

    public final int getFirstToken(int i) {
        return this.getToken(i);
    }

    public final int getLastToken() {
        return this.lastToken;
    }

    public final int getLastToken(int i) {
        return i >= this.prs.rhs(this.currentAction) ? this.lastToken : this.tokStream.getPrevious(this.getToken(i + 1));
    }

    public void resetTokenStream(int i) {
        this.tokStream.reset(i);
        this.curtok = this.tokStream.getToken();
        this.current_kind = this.tokStream.getKind(this.curtok);
    }

    public void parseCharacters(ParseTable prs, RuleAction ra) {
        this.pushPtRa(prs, ra);
        this.parseCharacters();
    }

    public void parseCharacters() {
        this.parseCharacters(null);
    }

    public void parseCharacters(Monitor monitor) {
        this.resetTokenStream(0);
        this.lastToken = this.tokStream.getPrevious(this.curtok);
        block0: while (this.current_kind != this.EOFT_SYMBOL) {
            if (monitor != null && monitor.isCancelled()) {
                return;
            }
            this.stateStackTop = -1;
            this.currentAction = this.START_STATE;
            this.starttok = this.curtok;
            ParseTable prs1 = this.prs;
            RuleAction ra1 = this.ra;
            int start_symbol = prs1.getStartSymbol();
            int num_rules = prs1.getNumRules();
            block1: while (true) {
                int lhs_symbol;
                if (++this.stateStackTop >= this.stackLength) {
                    this.reallocateStacks();
                }
                this.stack[this.stateStackTop] = this.currentAction;
                this.locationStack[this.stateStackTop] = this.curtok;
                this.currentAction = this.tAction(this.currentAction, this.current_kind);
                if (this.currentAction <= num_rules) {
                    --this.stateStackTop;
                    do {
                        lhs_symbol = prs1.lhs(this.currentAction);
                        int rule_size = prs1.rhs(this.currentAction);
                        this.stateStackTop -= rule_size - 1;
                        if (lhs_symbol == start_symbol) {
                            if (rule_size == 0) break block1;
                            ra1.ruleAction(this.currentAction);
                            continue block0;
                        }
                        ra1.ruleAction(this.currentAction);
                        this.currentAction = prs1.ntAction(this.stack[this.stateStackTop], lhs_symbol);
                    } while (this.currentAction <= num_rules);
                    continue;
                }
                if (this.currentAction > this.ERROR_ACTION) {
                    this.lastToken = this.curtok;
                    this.curtok = this.tokStream.getToken();
                    this.current_kind = this.tokStream.getKind(this.curtok);
                    this.currentAction -= this.ERROR_ACTION;
                    do {
                        lhs_symbol = prs1.lhs(this.currentAction);
                        this.stateStackTop -= prs1.rhs(this.currentAction) - 1;
                        if (lhs_symbol == start_symbol) {
                            ra1.ruleAction(this.currentAction);
                            continue block0;
                        }
                        ra1.ruleAction(this.currentAction);
                        this.currentAction = prs1.ntAction(this.stack[this.stateStackTop], lhs_symbol);
                    } while (this.currentAction <= num_rules);
                    continue;
                }
                if (this.currentAction >= this.ACCEPT_ACTION) break;
                this.lastToken = this.curtok;
                this.curtok = this.tokStream.getToken();
                this.current_kind = this.tokStream.getKind(this.curtok);
            }
            if (this.starttok == this.curtok) {
                if (this.current_kind == this.EOFT_SYMBOL) {
                    return;
                }
                this.tokStream.reportError(this.starttok, this.curtok);
                this.lastToken = this.curtok;
                this.curtok = this.tokStream.getToken();
                this.current_kind = this.tokStream.getKind(this.curtok);
                continue;
            }
            this.tokStream.makeToken(this.starttok, this.lastToken, 0);
        }
    }

    private final int tAction(int act, int sym) {
        if ((act = this.prs.tAction(act, sym)) > this.LA_STATE_OFFSET) {
            int next_token = this.tokStream.peek();
            act = this.prs.lookAhead(act - this.LA_STATE_OFFSET, this.tokStream.getKind(next_token));
            while (act > this.LA_STATE_OFFSET) {
                next_token = this.tokStream.getNext(next_token);
                act = this.prs.lookAhead(act - this.LA_STATE_OFFSET, this.tokStream.getKind(next_token));
            }
        }
        return act;
    }
}

