/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.mylyn.search;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.ElementChangedEvent;
import org.eclipse.dltk.core.IElementChangedListener;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementDelta;
import org.eclipse.dltk.internal.ui.search.DLTKSearchResult;
import org.eclipse.search.ui.IQueryListener;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search.ui.text.Match;

public class DLTKActiveSearchResultUpdater
implements IElementChangedListener,
IQueryListener {
    private final DLTKSearchResult fResult;
    private static final int REMOVED_FLAGS = 1185;

    public DLTKActiveSearchResultUpdater(DLTKSearchResult result) {
        this.fResult = result;
        NewSearchUI.addQueryListener((IQueryListener)this);
        DLTKCore.addElementChangedListener((IElementChangedListener)this);
    }

    public void elementChanged(ElementChangedEvent event) {
        IModelElementDelta delta = event.getDelta();
        HashSet<IAdaptable> removedElements = new HashSet<IAdaptable>();
        HashSet<IAdaptable> potentiallyRemovedElements = new HashSet<IAdaptable>();
        this.collectRemoved(potentiallyRemovedElements, removedElements, delta);
        if (removedElements.size() > 0) {
            this.handleRemoved(removedElements);
        }
        if (potentiallyRemovedElements.size() > 0) {
            this.handleRemoved(potentiallyRemovedElements);
        }
    }

    private void handleRemoved(Set<IAdaptable> removedElements) {
        Object[] elements;
        Object[] objectArray = elements = this.fResult.getElements();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (this.isContainedInRemoved(removedElements, element)) {
                IResource resource;
                Match matche;
                int n3;
                int n4;
                Match[] matchArray;
                Match[] matches;
                if (element instanceof IModelElement) {
                    IModelElement je = (IModelElement)element;
                    if (!je.exists()) {
                        matchArray = matches = this.fResult.getMatches(element);
                        n4 = matches.length;
                        n3 = 0;
                        while (n3 < n4) {
                            matche = matchArray[n3];
                            this.fResult.removeMatch(matche);
                            ++n3;
                        }
                    }
                } else if (element instanceof IResource && !(resource = (IResource)element).exists()) {
                    matchArray = matches = this.fResult.getMatches(element);
                    n4 = matches.length;
                    n3 = 0;
                    while (n3 < n4) {
                        matche = matchArray[n3];
                        this.fResult.removeMatch(matche);
                        ++n3;
                    }
                }
            }
            ++n2;
        }
    }

    private boolean isContainedInRemoved(Set<IAdaptable> removedElements, Object object) {
        for (IAdaptable iAdaptable : removedElements) {
            if (!this.isParentOf(iAdaptable, object)) continue;
            return true;
        }
        return false;
    }

    private boolean isParentOf(Object ancestor, Object descendant) {
        while (descendant != null && !ancestor.equals(descendant)) {
            descendant = this.getParent(descendant);
        }
        return descendant != null;
    }

    private Object getParent(Object object) {
        if (object instanceof IModelElement) {
            return ((IModelElement)object).getParent();
        }
        if (object instanceof IResource) {
            return ((IResource)object).getParent();
        }
        return null;
    }

    private void collectRemoved(Set<IAdaptable> potentiallyRemovedSet, Set<IAdaptable> removedElements, IModelElementDelta delta) {
        int n;
        if (delta.getKind() == 2) {
            removedElements.add((IAdaptable)delta.getElement());
        } else if (delta.getKind() == 4) {
            int flags = delta.getFlags();
            if ((flags & 0x4A1) != 0) {
                potentiallyRemovedSet.add((IAdaptable)delta.getElement());
            } else {
                IModelElementDelta[] childDeltas;
                IModelElementDelta[] iModelElementDeltaArray = childDeltas = delta.getAffectedChildren();
                int n2 = childDeltas.length;
                n = 0;
                while (n < n2) {
                    IModelElementDelta childDelta = iModelElementDeltaArray[n];
                    this.collectRemoved(potentiallyRemovedSet, removedElements, childDelta);
                    ++n;
                }
            }
        }
        IResourceDelta[] resourceDeltas = delta.getResourceDeltas();
        if (resourceDeltas != null) {
            IResourceDelta[] iResourceDeltaArray = resourceDeltas;
            n = resourceDeltas.length;
            int n3 = 0;
            while (n3 < n) {
                IResourceDelta resourceDelta = iResourceDeltaArray[n3];
                this.collectRemovals(removedElements, resourceDelta);
                ++n3;
            }
        }
    }

    public void queryAdded(ISearchQuery query) {
    }

    public void queryRemoved(ISearchQuery query) {
        if (this.fResult.equals(query.getSearchResult())) {
            DLTKCore.removeElementChangedListener((IElementChangedListener)this);
            NewSearchUI.removeQueryListener((IQueryListener)this);
        }
    }

    private void collectRemovals(Set<IAdaptable> removals, IResourceDelta delta) {
        if (delta.getKind() == 2) {
            removals.add((IAdaptable)delta.getResource());
        } else {
            IResourceDelta[] children;
            IResourceDelta[] iResourceDeltaArray = children = delta.getAffectedChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceDelta element = iResourceDeltaArray[n2];
                this.collectRemovals(removals, element);
                ++n2;
            }
        }
    }

    public void queryStarting(ISearchQuery query) {
    }

    public void queryFinished(ISearchQuery query) {
    }
}

