/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.editor.semantic.highlighting;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.internal.ui.editor.DLTKEditorMessages;
import org.eclipse.dltk.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.internal.ui.editor.semantic.highlighting.SemanticHighlightingPresenter;
import org.eclipse.dltk.internal.ui.text.IScriptReconcilingListener;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.editor.highlighting.HighlightedPosition;
import org.eclipse.dltk.ui.editor.highlighting.HighlightingStyle;
import org.eclipse.dltk.ui.editor.highlighting.ISemanticHighlightingUpdater;
import org.eclipse.dltk.ui.editor.highlighting.SemanticHighlighting;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPartSite;

public class SemanticHighlightingReconciler
implements IScriptReconcilingListener,
ITextInputListener {
    private ScriptEditor fEditor;
    private ISourceViewer fSourceViewer;
    private SemanticHighlightingPresenter fPresenter;
    private SemanticHighlighting[] fSemanticHighlightings;
    private HighlightingStyle[] fHighlightings;
    private Job fJob;
    private final Object fJobLock = new Object();
    private final Object fReconcileLock = new Object();
    private boolean fIsReconciling = false;
    private SemanticHighlightingPresenter fJobPresenter;
    private SemanticHighlighting[] fJobSemanticHighlightings;
    private HighlightingStyle[] fJobHighlightings;
    private ISemanticHighlightingUpdater positionUpdater;

    @Override
    public void aboutToBeReconciled() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reconciled(ISourceModule ast, boolean forced, IProgressMonitor progressMonitor) {
        block25: {
            block24: {
                Object object;
                if (this.positionUpdater == null) {
                    return;
                }
                Object object2 = this.fReconcileLock;
                synchronized (object2) {
                    if (this.fIsReconciling) {
                        return;
                    }
                    this.fIsReconciling = true;
                }
                this.fJobPresenter = this.fPresenter;
                this.fJobSemanticHighlightings = this.fSemanticHighlightings;
                this.fJobHighlightings = this.fHighlightings;
                try {
                    if (this.fJobPresenter != null && this.fJobSemanticHighlightings != null && this.fJobHighlightings != null) break block24;
                    this.fJobPresenter = null;
                    this.fJobSemanticHighlightings = null;
                    this.fJobHighlightings = null;
                    object = this.fReconcileLock;
                }
                catch (Throwable throwable) {
                    this.fJobPresenter = null;
                    this.fJobSemanticHighlightings = null;
                    this.fJobHighlightings = null;
                    Object object3 = this.fReconcileLock;
                    synchronized (object3) {
                        this.fIsReconciling = false;
                    }
                    throw throwable;
                }
                synchronized (object) {
                    this.fIsReconciling = false;
                }
                return;
            }
            this.fJobPresenter.setCanceled(progressMonitor.isCanceled());
            if (ast != null && !this.fJobPresenter.isCanceled()) break block25;
            this.fJobPresenter = null;
            this.fJobSemanticHighlightings = null;
            this.fJobHighlightings = null;
            Object object = this.fReconcileLock;
            synchronized (object) {
                this.fIsReconciling = false;
            }
            return;
        }
        HighlightedPosition[] added = HighlightedPosition.NO_POSITIONS;
        HighlightedPosition[] removed = HighlightedPosition.NO_POSITIONS;
        if (!this.fJobPresenter.isCanceled()) {
            ArrayList<HighlightedPosition> currentPositions = new ArrayList<HighlightedPosition>();
            this.fJobPresenter.addAllPositions(currentPositions);
            ISemanticHighlightingUpdater.UpdateResult result = this.positionUpdater.reconcile((IModuleSource)ast, currentPositions);
            added = result.addedPositions;
            removed = result.removedPositions;
        }
        if (!(added.length == 0 && removed.length == 0 || this.fJobPresenter.isCanceled())) {
            TextPresentation textPresentation = this.fJobPresenter.createPresentation(added, removed);
            if (!this.fJobPresenter.isCanceled()) {
                this.updatePresentation(textPresentation, added, removed);
            }
        }
        this.fJobPresenter = null;
        this.fJobSemanticHighlightings = null;
        this.fJobHighlightings = null;
        Object object = this.fReconcileLock;
        synchronized (object) {
            this.fIsReconciling = false;
        }
    }

    private void updatePresentation(TextPresentation textPresentation, HighlightedPosition[] addedPositions, HighlightedPosition[] removedPositions) {
        Runnable runnable = this.fJobPresenter.createUpdateRunnable(textPresentation, addedPositions, removedPositions);
        if (runnable == null) {
            return;
        }
        ScriptEditor editor = this.fEditor;
        if (editor == null) {
            return;
        }
        IWorkbenchPartSite site = editor.getSite();
        if (site == null) {
            return;
        }
        Shell shell = site.getShell();
        if (shell == null || shell.isDisposed()) {
            return;
        }
        Display display = shell.getDisplay();
        if (display == null || display.isDisposed()) {
            return;
        }
        display.asyncExec(runnable);
    }

    public void install(ScriptEditor editor, ISourceViewer sourceViewer, ISemanticHighlightingUpdater fHighlightingUpdater, SemanticHighlightingPresenter presenter, SemanticHighlighting[] semanticHighlightings, HighlightingStyle[] highlightings) {
        this.fPresenter = presenter;
        this.fSemanticHighlightings = semanticHighlightings;
        this.fHighlightings = highlightings;
        this.positionUpdater = fHighlightingUpdater;
        this.positionUpdater.initialize(this.fPresenter, this.fHighlightings);
        this.fEditor = editor;
        this.fSourceViewer = sourceViewer;
        if (this.fEditor != null) {
            this.fEditor.addReconcileListener(this);
        } else {
            this.fSourceViewer.addTextInputListener((ITextInputListener)this);
            this.scheduleJob();
        }
    }

    public void uninstall() {
        if (this.fPresenter != null) {
            this.fPresenter.setCanceled(true);
        }
        if (this.fEditor != null) {
            this.fEditor.removeReconcileListener(this);
            this.fEditor = null;
        } else {
            this.fSourceViewer.removeTextInputListener((ITextInputListener)this);
        }
        this.fSourceViewer = null;
        this.fSemanticHighlightings = null;
        this.fHighlightings = null;
        this.fPresenter = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleJob() {
        IModelElement element = this.fEditor.getInputModelElement();
        Object object = this.fJobLock;
        synchronized (object) {
            final Job oldJob = this.fJob;
            if (this.fJob != null) {
                this.fJob.cancel();
                this.fJob = null;
            }
            if (element != null) {
                this.fJob = new Job(DLTKEditorMessages.SemanticHighlighting_job){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    protected IStatus run(IProgressMonitor monitor) {
                        if (oldJob != null) {
                            try {
                                oldJob.join();
                            }
                            catch (InterruptedException e) {
                                DLTKUIPlugin.log(e);
                                return Status.CANCEL_STATUS;
                            }
                        }
                        if (monitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        ISourceModule code = DLTKUIPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(SemanticHighlightingReconciler.this.fEditor.getEditorInput());
                        SemanticHighlightingReconciler.this.reconciled(code, false, monitor);
                        Object object = SemanticHighlightingReconciler.this.fJobLock;
                        synchronized (object) {
                            if (SemanticHighlightingReconciler.this.fJob == this) {
                                SemanticHighlightingReconciler.this.fJob = null;
                            }
                        }
                        return Status.OK_STATUS;
                    }
                };
                this.fJob.setSystem(true);
                this.fJob.setPriority(50);
                this.fJob.schedule();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
        Object object = this.fJobLock;
        synchronized (object) {
            if (this.fJob != null) {
                this.fJob.cancel();
                this.fJob = null;
            }
        }
    }

    public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
        if (newInput != null) {
            this.scheduleJob();
        }
    }

    public void refresh() {
        this.scheduleJob();
    }
}

