/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mwe.ui.internal.simpleEditor;

import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;

public class XMLDoubleClickStrategy
implements ITextDoubleClickStrategy {
    private static final Pattern PATTERN_ATTRIBUTE_VALUE = Pattern.compile("\"(.*?)\"|'(.*?)'");
    protected ITextViewer fText;

    public void doubleClicked(ITextViewer part) {
        int pos = part.getSelectedRange().x;
        if (pos < 0) {
            return;
        }
        this.fText = part;
        if (!this.selectAttributeValue(pos)) {
            this.selectWord(pos);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean selectAttributeValue(int caretPos) {
        IDocument doc = this.fText.getDocument();
        try {
            MatchResult matchResult;
            IRegion lineInformationOfOffset = doc.getLineInformationOfOffset(caretPos);
            int offsetInLine = caretPos - lineInformationOfOffset.getOffset();
            String line = doc.get(lineInformationOfOffset.getOffset(), lineInformationOfOffset.getLength());
            Matcher matcher = PATTERN_ATTRIBUTE_VALUE.matcher(line);
            do {
                if (!matcher.find()) {
                    return false;
                }
                matchResult = matcher.toMatchResult();
                System.out.println("[" + matchResult.start(1) + ":" + matchResult.end(1) + "] " + matchResult.group(1));
            } while (matchResult.start(1) > offsetInLine || offsetInLine > matchResult.end(1));
            System.out.println("FOUND: [" + matchResult.start(1) + ":" + matchResult.end(1) + "] " + matchResult.group(1));
            this.selectRangeInLine(lineInformationOfOffset, (IRegion)new Region(matchResult.start(1), matchResult.end(1) - matchResult.start(1)));
            return true;
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return false;
    }

    protected boolean selectWord(int caretPos) {
        IDocument doc = this.fText.getDocument();
        try {
            char c;
            int pos = caretPos;
            while (pos >= 0) {
                c = doc.getChar(pos);
                if (!Character.isJavaIdentifierPart(c)) break;
                --pos;
            }
            int startPos = pos;
            pos = caretPos;
            int length = doc.getLength();
            while (pos < length) {
                c = doc.getChar(pos);
                if (!Character.isJavaIdentifierPart(c)) break;
                ++pos;
            }
            int endPos = pos;
            this.selectRange(startPos, endPos);
            return true;
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    private void selectRangeInLine(IRegion lineInformationOfOffset, IRegion selection) {
        int offset = lineInformationOfOffset.getOffset() + selection.getOffset();
        int length = selection.getLength();
        this.fText.setSelectedRange(offset, length);
    }

    private void selectRange(int startPos, int stopPos) {
        int offset = startPos + 1;
        int length = stopPos - offset;
        this.fText.setSelectedRange(offset, length);
    }
}

