/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.emf.ui.services.modelingassistant;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.gmf.runtime.common.core.service.AbstractProviderConfiguration;

public class ModelingAssistantProviderConfiguration
extends AbstractProviderConfiguration {
    private static final String CONTEXT = "context";
    private static final String OPERATION_ID = "operationId";
    private static final String ELEMENTS = "elements";
    private List contextDescriptors = new ArrayList();

    public static ModelingAssistantProviderConfiguration parse(IConfigurationElement configElement) {
        assert (configElement != null) : "null provider configuration element";
        return new ModelingAssistantProviderConfiguration(configElement);
    }

    private ModelingAssistantProviderConfiguration(IConfigurationElement configElement) {
        HashMap<String, AbstractProviderConfiguration.ObjectDescriptor> objects = new HashMap<String, AbstractProviderConfiguration.ObjectDescriptor>();
        IConfigurationElement[] configChildren = configElement.getChildren("object");
        int i = 0;
        while (i < configChildren.length) {
            String id = configChildren[i].getAttribute("id");
            if (id != null) {
                objects.put(id, new AbstractProviderConfiguration.ObjectDescriptor(configChildren[i]));
            }
            ++i;
        }
        configChildren = configElement.getChildren(CONTEXT);
        i = 0;
        while (i < configChildren.length) {
            String operationType = configChildren[i].getAttribute(OPERATION_ID);
            List elements = ModelingAssistantProviderConfiguration.getObjectList((String)configChildren[i].getAttribute(ELEMENTS), objects, (IConfigurationElement)configElement);
            if (operationType != null || elements != null) {
                this.contextDescriptors.add(new ContextDescriptor(operationType, elements));
            }
            ++i;
        }
    }

    public boolean supports(String operationType, IAdaptable context) {
        if (this.contextDescriptors.isEmpty()) {
            return true;
        }
        for (ContextDescriptor descriptor : this.contextDescriptors) {
            if (!descriptor.matches(operationType, context)) continue;
            return true;
        }
        return false;
    }

    private static class ContextDescriptor {
        private final String operationType;
        private final List elements;

        public ContextDescriptor(String operationType, List elements) {
            this.operationType = operationType;
            this.elements = elements;
        }

        public boolean matches(String anOperationType, IAdaptable context) {
            if (this.operationType != null && !this.operationType.equals(anOperationType)) {
                return false;
            }
            return this.elements == null || ModelingAssistantProviderConfiguration.objectMatches((Object)context, (List)this.elements);
        }
    }
}

