/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.persistence;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jpt.common.core.internal.utility.ValidationMessageTools;
import org.eclipse.jpt.common.core.utility.ValidationMessage;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.jpa.core.JpaFile;
import org.eclipse.jpt.jpa.core.JpaStructureNode;
import org.eclipse.jpt.jpa.core.context.Generator;
import org.eclipse.jpt.jpa.core.context.ManagedType;
import org.eclipse.jpt.jpa.core.context.MappingFile;
import org.eclipse.jpt.jpa.core.context.MappingFilePersistenceUnitMetadata;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.context.Query;
import org.eclipse.jpt.jpa.core.context.persistence.MappingFileRef;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.core.internal.context.persistence.AbstractPersistenceXmlContextModel;
import org.eclipse.jpt.jpa.core.validation.JptJpaCoreValidationMessages;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

public abstract class AbstractMappingFileRef<MF extends MappingFile>
extends AbstractPersistenceXmlContextModel<PersistenceUnit>
implements MappingFileRef {
    protected String fileName;
    protected MF mappingFile;

    protected AbstractMappingFileRef(PersistenceUnit parent, String fileName) {
        super(parent);
        this.fileName = fileName;
        this.mappingFile = this.buildMappingFile();
    }

    @Override
    public void synchronizeWithResourceModel(IProgressMonitor monitor) {
        super.synchronizeWithResourceModel(monitor);
        this.syncMappingFile(monitor);
    }

    @Override
    public void update(IProgressMonitor monitor) {
        super.update(monitor);
        this.updateMappingFile(monitor);
    }

    @Override
    public void addRootStructureNodesTo(JpaFile jpaFile, Collection<JpaStructureNode> rootStructureNodes) {
        if (this.mappingFile != null) {
            this.mappingFile.addRootStructureNodesTo(jpaFile, rootStructureNodes);
        }
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    protected boolean isIn(IFolder folder) {
        return this.mappingFile != null && this.mappingFile.isIn(folder);
    }

    @Override
    public MappingFile getMappingFile() {
        return this.mappingFile;
    }

    protected void setMappingFile(MF mappingFile) {
        MF old = this.mappingFile;
        this.mappingFile = mappingFile;
        this.firePropertyChanged("mappingFile", old, mappingFile);
    }

    protected abstract MF buildMappingFile();

    protected void syncMappingFile(IProgressMonitor monitor) {
        this.syncMappingFile(true, monitor);
    }

    protected void syncMappingFile(boolean sync, IProgressMonitor monitor) {
        Object newResourceMappingFile = this.resolveResourceMappingFile();
        if (newResourceMappingFile == null) {
            this.setMappingFile(null);
        } else if (this.mappingFile == null) {
            this.setMappingFile(this.buildMappingFile(newResourceMappingFile));
        } else if (this.mappingFile.getResourceMappingFile() == newResourceMappingFile) {
            if (sync) {
                this.mappingFile.synchronizeWithResourceModel(monitor);
            } else {
                this.mappingFile.update(monitor);
            }
        } else {
            this.setMappingFile(this.buildMappingFile(newResourceMappingFile));
        }
    }

    protected abstract Object resolveResourceMappingFile();

    protected MF buildMappingFile(Object resourceMappingFile) {
        return (MF)this.getJpaFactory().buildMappingFile(this, resourceMappingFile);
    }

    protected void updateMappingFile(IProgressMonitor monitor) {
        this.syncMappingFile(false, monitor);
    }

    @Override
    public JpaStructureNode.ContextType getContextType() {
        return new JpaStructureNode.ContextType(this);
    }

    @Override
    public Class<MappingFileRef> getStructureType() {
        return MappingFileRef.class;
    }

    @Override
    public JpaStructureNode getStructureNode(int textOffset) {
        return this;
    }

    public Iterable<JpaStructureNode> getStructureChildren() {
        return IterableTools.emptyIterable();
    }

    @Override
    public int getStructureChildrenSize() {
        return 0;
    }

    @Override
    public Iterable<Query> getMappingFileQueries() {
        return this.mappingFile != null ? this.mappingFile.getMappingFileQueries() : EmptyIterable.instance();
    }

    @Override
    public Iterable<Generator> getMappingFileGenerators() {
        return this.mappingFile != null ? this.mappingFile.getMappingFileGenerators() : EmptyIterable.instance();
    }

    @Override
    public boolean persistenceUnitMetadataExists() {
        MappingFilePersistenceUnitMetadata metadata = this.getPersistenceUnitMetadata();
        return metadata != null && metadata.resourceExists();
    }

    @Override
    public MappingFilePersistenceUnitMetadata getPersistenceUnitMetadata() {
        MappingFile.Root root = this.getChildMappingFileRoot();
        return root == null ? null : root.getPersistenceUnitMetadata();
    }

    protected MappingFile.Root getChildMappingFileRoot() {
        return this.mappingFile == null ? null : this.mappingFile.getRoot();
    }

    @Override
    public PersistentType getPersistentType(String typeName) {
        return this.mappingFile == null ? null : this.mappingFile.getPersistentType(typeName);
    }

    @Override
    public Iterable<? extends PersistentType> getPersistentTypes() {
        return this.mappingFile != null ? this.mappingFile.getPersistentTypes() : EmptyIterable.instance();
    }

    @Override
    public Iterable<? extends ManagedType> getManagedTypes() {
        return this.mappingFile != null ? this.mappingFile.getManagedTypes() : EmptyIterable.instance();
    }

    @Override
    public ManagedType getManagedType(String typeName) {
        return this.mappingFile == null ? null : this.mappingFile.getManagedType(typeName);
    }

    public void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(this.fileName);
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        if (StringTools.isBlank((String)this.fileName)) {
            messages.add(this.buildValidationMessage(this.getValidationTextRange(), JptJpaCoreValidationMessages.PERSISTENCE_UNIT_UNSPECIFIED_MAPPING_FILE));
            return;
        }
        if (this.mappingFile == null) {
            messages.add(this.buildMissingMappingFileValidationMessage());
            return;
        }
        this.mappingFile.validate(messages, reporter);
    }

    protected IMessage buildMissingMappingFileValidationMessage() {
        IFile file = this.getPlatformFile();
        if (!file.exists()) {
            return this.buildValidationMessage(this.getValidationTextRange(), JptJpaCoreValidationMessages.PERSISTENCE_UNIT_NONEXISTENT_MAPPING_FILE, this.fileName);
        }
        ValidationMessage msg = this.mappingFileContentIsUnsupported() ? JptJpaCoreValidationMessages.PERSISTENCE_UNIT_UNSUPPORTED_MAPPING_FILE_CONTENT : JptJpaCoreValidationMessages.PERSISTENCE_UNIT_INVALID_MAPPING_FILE;
        return ValidationMessageTools.buildValidationMessage((IResource)file, (ValidationMessage)msg, (Object[])new Object[]{file.getName()});
    }

    protected IFile getPlatformFile() {
        return this.getJpaProject().getPlatformFile((IPath)new Path(this.fileName));
    }

    protected abstract boolean mappingFileContentIsUnsupported();

    @Override
    public Iterable<DeleteEdit> createDeleteTypeEdits(IType type) {
        return this.mappingFile != null ? this.mappingFile.createDeleteTypeEdits(type) : IterableTools.emptyIterable();
    }

    @Override
    public Iterable<ReplaceEdit> createRenameTypeEdits(IType originalType, String newName) {
        return this.mappingFile != null ? this.mappingFile.createRenameTypeEdits(originalType, newName) : IterableTools.emptyIterable();
    }

    @Override
    public Iterable<ReplaceEdit> createMoveTypeEdits(IType originalType, IPackageFragment newPackage) {
        return this.mappingFile != null ? this.mappingFile.createMoveTypeEdits(originalType, newPackage) : IterableTools.emptyIterable();
    }

    @Override
    public Iterable<ReplaceEdit> createRenamePackageEdits(IPackageFragment originalPackage, String newName) {
        return this.mappingFile != null ? this.mappingFile.createRenamePackageEdits(originalPackage, newName) : IterableTools.emptyIterable();
    }

    @Override
    public Iterable<ReplaceEdit> createRenameMappingFileEdits(IFile originalFile, String newName) {
        return this.isFor(originalFile) ? IterableTools.singletonIterable((Object)this.createRenameEdit(originalFile, newName)) : IterableTools.emptyIterable();
    }

    protected abstract ReplaceEdit createRenameEdit(IFile var1, String var2);

    @Override
    public Iterable<ReplaceEdit> createMoveMappingFileEdits(IFile originalFile, IPath runtineDestination) {
        return this.isFor(originalFile) ? IterableTools.singletonIterable((Object)this.createMoveEdit(originalFile, runtineDestination)) : IterableTools.emptyIterable();
    }

    protected abstract ReplaceEdit createMoveEdit(IFile var1, IPath var2);

    protected boolean isFor(IFile file) {
        return this.mappingFile != null && file.equals((Object)this.mappingFile.getResource());
    }
}

