/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.common.exportmodel;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.common.internal.modulecore.AddClasspathFoldersParticipant;
import org.eclipse.jst.common.internal.modulecore.AddClasspathLibReferencesParticipant;
import org.eclipse.jst.j2ee.internal.archive.ComponentArchiveLoadAdapter;
import org.eclipse.jst.j2ee.internal.archive.JavaEEArchiveUtilities;
import org.eclipse.jst.j2ee.internal.archive.operations.AppClientArchiveOpsResourceHandler;
import org.eclipse.jst.j2ee.internal.archive.operations.FlatComponentArchiver;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.jee.archive.ArchiveException;
import org.eclipse.jst.jee.archive.ArchiveSaveFailureException;
import org.eclipse.jst.jee.archive.IArchive;
import org.eclipse.jst.jee.archive.IArchiveLoadAdapter;
import org.eclipse.jst.jee.archive.IArchiveResource;
import org.eclipse.jst.jee.archive.internal.ArchiveUtil;
import org.eclipse.wst.common.componentcore.internal.flat.AbstractFlattenParticipant;
import org.eclipse.wst.common.componentcore.internal.flat.FlatVirtualComponent;
import org.eclipse.wst.common.componentcore.internal.flat.IChildModuleReference;
import org.eclipse.wst.common.componentcore.internal.flat.IFlatResource;
import org.eclipse.wst.common.componentcore.internal.flat.IFlatVirtualComponent;
import org.eclipse.wst.common.componentcore.internal.flat.IFlattenParticipant;
import org.eclipse.wst.common.componentcore.internal.flat.VirtualComponentFlattenUtility;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;

public class JavaEEComponentExportCallback
implements FlatComponentArchiver.ComponentExportCallback {
    private boolean isExportSource;
    private List<IPath> zipEntries;

    public JavaEEComponentExportCallback(boolean exportSource) {
        this.isExportSource = exportSource;
    }

    @Override
    public boolean canSave(IVirtualComponent component) {
        return JavaEEProjectUtilities.isJCAComponent(component);
    }

    @Override
    public IFlatVirtualComponent saveComponent(IVirtualComponent component, ZipOutputStream zipOutputStream, List<IPath> entries) throws ArchiveException {
        IArchive archiveToSave = null;
        this.zipEntries = entries;
        try {
            try {
                archiveToSave = JavaEEArchiveUtilities.INSTANCE.openArchive(component);
                IArchiveLoadAdapter loadAdapter = archiveToSave.getLoadAdapter();
                if (loadAdapter instanceof ComponentArchiveLoadAdapter) {
                    ComponentArchiveLoadAdapter cLoadAdapter = (ComponentArchiveLoadAdapter)loadAdapter;
                    cLoadAdapter.setExportSource(this.isExportSource());
                }
                List files = archiveToSave.getArchiveResources();
                this.saveManifest(archiveToSave, zipOutputStream);
                for (IArchiveResource file : files) {
                    if (this.isManifest(file.getPath())) continue;
                    this.addZipEntry(zipOutputStream, file);
                }
            }
            catch (Exception e) {
                throw new ArchiveException(AppClientArchiveOpsResourceHandler.ARCHIVE_OPERATION_OpeningArchive, (Throwable)e);
            }
        }
        finally {
            if (archiveToSave != null) {
                JavaEEArchiveUtilities.INSTANCE.closeArchive(archiveToSave);
            }
        }
        return this.getFlatComponent(component);
    }

    private boolean isManifest(IPath path) {
        return path.equals((Object)new Path("META-INF/MANIFEST.MF"));
    }

    private void saveManifest(IArchive archiveToSave, ZipOutputStream zipOutputStream) throws FileNotFoundException, ArchiveSaveFailureException {
        IArchiveResource manifest = null;
        if (archiveToSave.containsArchiveResource((IPath)new Path("META-INF/MANIFEST.MF"))) {
            manifest = archiveToSave.getArchiveResource((IPath)new Path("META-INF/MANIFEST.MF"));
            this.addZipEntry(zipOutputStream, manifest);
        }
    }

    protected void addZipEntry(ZipOutputStream zipOutputStream, IArchiveResource resource) throws ArchiveSaveFailureException {
        try {
            IPath path = resource.getPath();
            if (resource.getType() == 1 && !path.hasTrailingSeparator()) {
                path = path.addTrailingSeparator();
            }
            ZipEntry entry = new ZipEntry(path.toString());
            if (resource.getLastModified() > 0L) {
                entry.setTime(resource.getLastModified());
            }
            zipOutputStream.putNextEntry(entry);
            this.zipEntries.add(path);
            if (resource.getType() != 1) {
                ArchiveUtil.copy((InputStream)resource.getInputStream(), (OutputStream)zipOutputStream);
            }
            zipOutputStream.closeEntry();
        }
        catch (IOException e) {
            throw new ArchiveSaveFailureException((Throwable)e);
        }
    }

    protected IFlatVirtualComponent getFlatComponent(IVirtualComponent component) {
        FlatVirtualComponent.FlatComponentTaskModel options = new FlatVirtualComponent.FlatComponentTaskModel();
        options.put((Object)"org.eclipse.wst.common.componentcore.export.participantList", (Object)this.getParticipants());
        return new ConnectorExportComponent(component, options);
    }

    protected IFlattenParticipant[] getParticipants() {
        return new IFlattenParticipant[]{this.createHierarchyParticipant(), new AddClasspathLibReferencesParticipant(), new AddClasspathFoldersParticipant()};
    }

    protected IFlattenParticipant createHierarchyParticipant() {
        return new AbstractFlattenParticipant(){

            public boolean isChildModule(IVirtualComponent rootComponent, IVirtualReference reference, FlatVirtualComponent.FlatComponentTaskModel dataModel) {
                return !reference.getReferencedComponent().isBinary();
            }
        };
    }

    private boolean isExportSource() {
        return this.isExportSource;
    }

    @Override
    public boolean createManifest() {
        return false;
    }

    public class ConnectorExportComponent
    extends FlatVirtualComponent {
        public ConnectorExportComponent(IVirtualComponent component, FlatVirtualComponent.FlatComponentTaskModel dataModel) {
            super(component, dataModel);
        }

        protected boolean canOptimize() {
            return true;
        }

        protected void optimize(List<IFlatResource> resources, List<IChildModuleReference> children) {
            if (this.getComponent() != null) {
                VirtualComponentFlattenUtility util = new VirtualComponentFlattenUtility(resources, (VirtualComponentFlattenUtility.ShouldIncludeUtilityCallback)this);
                try {
                    this.addConsumedReferences(util, this.getComponent(), (IPath)new Path(""));
                    this.addUsedReferences(util, this.getComponent(), (IPath)new Path(""));
                }
                catch (CoreException e) {
                    J2EEPlugin.logError(e);
                }
            }
        }
    }
}

