/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.jsf.ui.commands.jsfhtml;

import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jst.pagedesigner.commands.DesignerCommand;
import org.eclipse.jst.pagedesigner.jsf.core.dom.JSFDOMUtil;
import org.eclipse.jst.pagedesigner.jsf.ui.commands.jsfhtml.CommandResources;
import org.eclipse.jst.pagedesigner.viewer.IHTMLGraphicalViewer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PanelGridInsertFooterCommand
extends DesignerCommand {
    private Element _panelGrid;

    public PanelGridInsertFooterCommand(IHTMLGraphicalViewer viewer, Element panelGrid) {
        super(CommandResources.getString("PanelGridInsertFooterCommand.Label.InsertFooter"), viewer);
        this._panelGrid = panelGrid;
    }

    public boolean canExecute() {
        boolean hasHeader;
        boolean bl = hasHeader = JSFDOMUtil.findFacet(this._panelGrid, "footer") != null;
        if (hasHeader) {
            return false;
        }
        return super.canExecute();
    }

    protected void doExecute() {
        Document doc = this._panelGrid.getOwnerDocument();
        Element facet = doc.createElement("facet");
        facet.setPrefix("f");
        facet.setAttribute("name", "footer");
        Element outputText = doc.createElement("outputText");
        outputText.setPrefix("h");
        outputText.setAttribute("value", "Footer");
        facet.appendChild(outputText);
        List list = JSFDOMUtil.getUIComponentChildren(this._panelGrid);
        if (list != null && list.size() > 0) {
            this._panelGrid.insertBefore(facet, (Element)list.get(0));
        } else {
            this._panelGrid.insertBefore(facet, null);
        }
        this.formatNode(this._panelGrid);
    }

    protected ISelection getAfterCommandDesignerSelection() {
        return this.toDesignSelection(this._panelGrid);
    }
}

