/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.runner;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.m2m.atl.adt.runner.CreateRunnableData;

public class ATLProperties
extends Properties {
    public static final String MODULES_ID = "modules";
    public static final String METAMODELS_ID = "metamodels";
    public static final String LIBRARIES_ID = "libraries";
    public static final String OPTIONS_ID = "options";
    private static final long serialVersionUID = -6057251615280415740L;
    private IFile file;
    private String name;

    public ATLProperties(IFile file) throws IOException, CoreException {
        this.file = file;
        InputStream is = file.getContents();
        this.load(is);
        is.close();
        this.name = file.getFullPath().removeFileExtension().lastSegment();
    }

    public IFile getIFile() {
        return this.file;
    }

    public Map<String, String> getMetamodelLocations() {
        return this.getMapFromProperties(String.valueOf(this.name) + '.' + METAMODELS_ID + '.');
    }

    public Map<String, String> getOptions() {
        return this.getMapFromProperties(String.valueOf(this.name) + '.' + OPTIONS_ID + '.');
    }

    public Map<String, String> getLibraryLocations() {
        return this.getMapFromProperties(String.valueOf(this.name) + '.' + LIBRARIES_ID + '.');
    }

    public IFile[] getTransformationFiles() {
        String[] moduleFileNames = null;
        String modulesList = this.getProperty(String.valueOf(this.name) + '.' + MODULES_ID);
        if (modulesList != null) {
            moduleFileNames = modulesList.split(",");
            ArrayList<IFile> atlModules = new ArrayList<IFile>();
            String[] stringArray = moduleFileNames;
            int n = moduleFileNames.length;
            int n2 = 0;
            while (n2 < n) {
                String moduleFileName = stringArray[n2];
                IResource member = this.file.getParent().findMember(moduleFileName.trim());
                if (member != null) {
                    IFile moduleFile = CreateRunnableData.getFile(member.getFullPath().toString());
                    atlModules.add(moduleFile);
                }
                ++n2;
            }
            return atlModules.toArray(new IFile[atlModules.size()]);
        }
        return null;
    }

    private Map<String, String> getMapFromProperties(String prefix) {
        HashMap<String, String> res = new HashMap<String, String>();
        for (Map.Entry<Object, Object> property : this.entrySet()) {
            if (!property.getKey().toString().startsWith(prefix)) continue;
            String key = property.getKey().toString().replaceFirst(prefix, "");
            String value = property.getValue().toString();
            if ("".equals(value.trim())) continue;
            res.put(key, value);
        }
        return res;
    }
}

