/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.eventmanager.framework;

import java.util.ArrayList;
import java.util.Collection;

public class ListenerTypeEnum {
    private static final int preChange_int = 2;
    private static final int postChange_int = 4;
    private static final int preCommit_int = 8;
    private static final int postCommit_int = 16;
    public static final ListenerTypeEnum preChange = new ListenerTypeEnum(2, "PreChange");
    public static final ListenerTypeEnum postChange = new ListenerTypeEnum(4, "PostChange");
    public static final ListenerTypeEnum preCommit = new ListenerTypeEnum(8, "PreCommit");
    public static final ListenerTypeEnum postCommit = new ListenerTypeEnum(16, "PostCommit");
    public static final Collection<ListenerTypeEnum> allListenerTypes = new ArrayList<ListenerTypeEnum>(4);
    private int myListenerTypes = 0;
    private String humanReadableRepresentation = null;

    static {
        allListenerTypes.add(preChange);
        allListenerTypes.add(postChange);
        allListenerTypes.add(preCommit);
        allListenerTypes.add(postCommit);
    }

    private ListenerTypeEnum(Integer listenerType, String name) {
        this.myListenerTypes = listenerType;
        this.humanReadableRepresentation = String.valueOf(name) + "-";
    }

    public ListenerTypeEnum(ListenerTypeEnum ... listenerTypes) {
        ListenerTypeEnum[] listenerTypeEnumArray = listenerTypes;
        int n = listenerTypes.length;
        int n2 = 0;
        while (n2 < n) {
            ListenerTypeEnum ltEnum = listenerTypeEnumArray[n2];
            this.myListenerTypes += ltEnum.myListenerTypes;
            this.humanReadableRepresentation = String.valueOf(this.humanReadableRepresentation) + ltEnum.humanReadableRepresentation + "-";
            ++n2;
        }
    }

    public boolean matches(ListenerTypeEnum other) {
        return (this.myListenerTypes & other.myListenerTypes) != 0;
    }

    public String toString() {
        return "ListenerType:" + this.humanReadableRepresentation + "Listener";
    }
}

