/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.library.collection;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CallExp;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.library.AbstractSimpleUnaryOperation;
import org.eclipse.ocl.pivot.library.numeric.NumericMaxOperation;
import org.eclipse.ocl.pivot.messages.PivotMessages;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.values.CollectionValue;
import org.eclipse.ocl.pivot.values.InvalidValueException;

public class CollectionMaxOperation
extends AbstractSimpleUnaryOperation {
    public static final @NonNull CollectionMaxOperation INSTANCE = new CollectionMaxOperation();

    @Override
    public @NonNull Object evaluate(@Nullable Object sourceVal) {
        CollectionValue collectionValue = CollectionMaxOperation.asCollectionValue(sourceVal);
        Object result = null;
        for (Object object : collectionValue.iterable()) {
            if (result == null) {
                result = object;
                continue;
            }
            if (object == null) continue;
            result = NumericMaxOperation.INSTANCE.evaluate(result, object);
        }
        if (result == null) {
            throw new InvalidValueException(PivotMessages.EmptyCollection, collectionValue.getKind(), "max");
        }
        return result;
    }

    @Override
    public @Nullable Type resolveReturnType(@NonNull EnvironmentFactory environmentFactory, @NonNull CallExp callExp, @Nullable Type returnType) {
        return this.resolveCollectionSourceReturnType(environmentFactory, callExp, returnType);
    }
}

