/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.formatter.ui.preferences;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.php.formatter.core.profiles.CodeFormatterPreferences;
import org.eclipse.php.formatter.ui.FormatterMessages;
import org.eclipse.php.formatter.ui.preferences.CodeFormatterPreview;
import org.eclipse.php.formatter.ui.preferences.ModifyDialog;
import org.eclipse.php.formatter.ui.preferences.ModifyDialogTabPage;
import org.eclipse.php.formatter.ui.preferences.PHPPreview;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;

public class CommentsTabPage
extends ModifyDialogTabPage {
    private boolean isInitialized = false;
    private final String LINE_SEPARATOR = System.getProperty("line.separator");
    private final String PREVIEW = "<?php" + this.LINE_SEPARATOR + "\t/**       " + this.LINE_SEPARATOR + " * This is the header comment." + this.LINE_SEPARATOR + "\t * \ttest" + this.LINE_SEPARATOR + " */" + this.LINE_SEPARATOR + "\t/**" + this.LINE_SEPARATOR + " * This is the comment for the example interface." + this.LINE_SEPARATOR + " */" + this.LINE_SEPARATOR + " interface Example {" + this.LINE_SEPARATOR + "// This is a long comment    with\twhitespace     that should be split in multiple line comments in case the line comment formatting is enabled" + this.LINE_SEPARATOR + "function foo3();" + this.LINE_SEPARATOR + " " + this.LINE_SEPARATOR + "//\tfunction commented() {" + this.LINE_SEPARATOR + "//\t\t\techo(\"indented\");" + this.LINE_SEPARATOR + "//\t}" + this.LINE_SEPARATOR + this.LINE_SEPARATOR + "\t//\tfunction indentedCommented() {" + this.LINE_SEPARATOR + "\t//\t\t\techo(\"indented\");" + this.LINE_SEPARATOR + "\t//\t}" + this.LINE_SEPARATOR + this.LINE_SEPARATOR + "/* block comment          on first column*/" + this.LINE_SEPARATOR + " function bar();" + this.LINE_SEPARATOR + "\t/*" + this.LINE_SEPARATOR + "\t*" + this.LINE_SEPARATOR + "\t* These possibilities include:" + this.LINE_SEPARATOR + "\t* <ul><li>Formatting of header comments.</li><li>Formatting of Javadoc tags</li></ul>" + this.LINE_SEPARATOR + "\t*/" + this.LINE_SEPARATOR + " function bar2(); // This is a long comment that should be split in multiple line comments in case the line comment formatting is enabled" + this.LINE_SEPARATOR + " /**" + this.LINE_SEPARATOR + " * The following is some sample code which illustrates source formatting within javadoc comments:" + this.LINE_SEPARATOR + " * Descriptions of parameters and return values are best appended at end of the javadoc comment." + this.LINE_SEPARATOR + " * @Orm\\Unknown\\Tag()   This is an unknown PHPDoc tag," + this.LINE_SEPARATOR + " *       but could be a PHP framework annotation" + this.LINE_SEPARATOR + " * @param $a int The first parameter. For an optimum result, this should be an odd number" + this.LINE_SEPARATOR + " * between 0 and 100." + this.LINE_SEPARATOR + " * @param $b int The second parameter." + this.LINE_SEPARATOR + " * @return int The result of the foo operation, usually within 0 and 1000." + this.LINE_SEPARATOR + " */ function foo(int $a, int $b);" + this.LINE_SEPARATOR + " /**" + this.LINE_SEPARATOR + " * @param $a int The first parameter." + this.LINE_SEPARATOR + " * @return int The result of the foo2 operation." + this.LINE_SEPARATOR + " */ function foo2(int $a);" + this.LINE_SEPARATOR + "}" + this.LINE_SEPARATOR + "// This is a long comment    with\twhitespace     that should be split in multiple line comments in case the line comment formatting is enabled" + this.LINE_SEPARATOR + "class Test {" + this.LINE_SEPARATOR + "\t\tfunction trailingCommented() {" + this.LINE_SEPARATOR + "\t\t\t\techo(\"indented\");\t\t// comment" + this.LINE_SEPARATOR + "\t\t\t\techo(\"indent\");\t\t// comment" + this.LINE_SEPARATOR + "\t\t}" + this.LINE_SEPARATOR + "}";
    private CodeFormatterPreview fPreview;
    private ModifyDialogTabPage.CheckboxPreference javadoc;
    private ModifyDialogTabPage.CheckboxPreference blockComment;
    private ModifyDialogTabPage.CheckboxPreference singleLineComments;
    private ModifyDialogTabPage.CheckboxPreference singleLineCommentsOnFirstColumn;
    private ModifyDialogTabPage.CheckboxPreference header;
    private ModifyDialogTabPage.CheckboxPreference chkbox2;
    private ModifyDialogTabPage.CheckboxPreference chkbox3;
    private ModifyDialogTabPage.CheckboxPreference chkbox4;
    private ModifyDialogTabPage.CheckboxPreference blankJavadoc;
    private ModifyDialogTabPage.CheckboxPreference blankRootDesc;
    private ModifyDialogTabPage.CheckboxPreference indentJavadoc;
    private ModifyDialogTabPage.CheckboxPreference indentDesc;
    private ModifyDialogTabPage.CheckboxPreference nerverFormatUnknownTags;
    private ModifyDialogTabPage.CheckboxPreference nlParam;
    private ModifyDialogTabPage.CheckboxPreference nlBoundariesJavadoc;
    private ModifyDialogTabPage.CheckboxPreference blankLinesJavadoc;
    private ModifyDialogTabPage.CheckboxPreference nlBoundariesBlock;
    private ModifyDialogTabPage.CheckboxPreference blankLinesBlock;
    private ModifyDialogTabPage.NumberPreference lineWidth;

    public CommentsTabPage(ModifyDialog modifyDialog, CodeFormatterPreferences codeFormatterPreferences) {
        super(modifyDialog, codeFormatterPreferences);
    }

    @Override
    protected void doCreatePreferences(Composite composite, int numColumns) {
        int indent = this.fPixelConverter.convertWidthInCharsToPixels(4);
        Group globalGroup = this.createGroup(numColumns, composite, FormatterMessages.CommentsTabPage_group1_title);
        this.javadoc = this.createCheckboxPref((Composite)globalGroup, numColumns, FormatterMessages.commentsTabPage_enable_javadoc_comment_formatting);
        this.javadoc.setIsChecked(this.codeFormatterPreferences.comment_format_javadoc_comment);
        this.blockComment = this.createCheckboxPref((Composite)globalGroup, numColumns, FormatterMessages.CommentsTabPage_enable_block_comment_formatting);
        this.blockComment.setIsChecked(this.codeFormatterPreferences.comment_format_block_comment);
        this.singleLineComments = this.createCheckboxPref((Composite)globalGroup, numColumns, FormatterMessages.CommentsTabPage_enable_line_comment_formatting);
        this.singleLineComments.setIsChecked(this.codeFormatterPreferences.comment_format_line_comment);
        this.singleLineCommentsOnFirstColumn = this.createCheckboxPref((Composite)globalGroup, numColumns, FormatterMessages.CommentsTabPage_format_line_comments_on_first_column);
        this.singleLineCommentsOnFirstColumn.setIsChecked(this.codeFormatterPreferences.comment_format_line_comment_starting_on_first_column);
        ((GridData)this.singleLineCommentsOnFirstColumn.getControl().getLayoutData()).horizontalIndent = indent;
        this.header = this.createCheckboxPref((Composite)globalGroup, numColumns, FormatterMessages.CommentsTabPage_format_header);
        this.header.setIsChecked(this.codeFormatterPreferences.comment_format_header);
        GridData spacerData = new GridData(0, 0);
        spacerData.horizontalSpan = numColumns;
        new Composite((Composite)globalGroup, 0).setLayoutData((Object)spacerData);
        this.chkbox2 = this.createCheckboxPref((Composite)globalGroup, numColumns, FormatterMessages.CommentsTabPage_never_indent_line_comments_on_first_column);
        this.chkbox2.setIsChecked(this.codeFormatterPreferences.never_indent_line_comments_on_first_column);
        this.chkbox3 = this.createCheckboxPref((Composite)globalGroup, numColumns, FormatterMessages.CommentsTabPage_never_indent_block_comments_on_first_column);
        this.chkbox3.setIsChecked(this.codeFormatterPreferences.never_indent_block_comments_on_first_column);
        this.chkbox4 = this.createCheckboxPref((Composite)globalGroup, numColumns, FormatterMessages.CommentsTabPage_do_not_join_lines);
        this.chkbox4.setIsChecked(this.codeFormatterPreferences.join_lines_in_comments);
        Group settingsGroup = this.createGroup(numColumns, composite, FormatterMessages.CommentsTabPage_group2_title);
        this.blankJavadoc = this.createCheckboxPref((Composite)settingsGroup, numColumns, FormatterMessages.CommentsTabPage_blank_line_before_javadoc_tags);
        this.blankJavadoc.setIsChecked(this.codeFormatterPreferences.comment_insert_empty_line_before_root_tags);
        this.blankRootDesc = this.createCheckboxPref((Composite)settingsGroup, numColumns, FormatterMessages.CommentsTabPage_keep_blank_line_for_empty_description);
        this.blankRootDesc.setIsChecked(this.codeFormatterPreferences.comment_keep_empty_line_for_empty_description);
        ((GridData)this.blankRootDesc.getControl().getLayoutData()).horizontalIndent = indent;
        this.indentJavadoc = this.createCheckboxPref((Composite)settingsGroup, numColumns, FormatterMessages.CommentsTabPage_indent_javadoc_tags);
        this.indentJavadoc.setIsChecked(this.codeFormatterPreferences.comment_indent_root_tags);
        this.indentDesc = this.createCheckboxPref((Composite)settingsGroup, numColumns, FormatterMessages.CommentsTabPage_indent_description_after_param);
        this.indentDesc.setIsChecked(this.codeFormatterPreferences.comment_indent_parameter_description);
        ((GridData)this.indentDesc.getControl().getLayoutData()).horizontalIndent = indent;
        this.nerverFormatUnknownTags = this.createCheckboxPref((Composite)settingsGroup, numColumns, FormatterMessages.CommentsTabPage_never_format_unknown_tags);
        this.nerverFormatUnknownTags.setIsChecked(this.codeFormatterPreferences.comment_never_format_unknown_tags);
        this.nlParam = this.createPrefInsert((Composite)settingsGroup, numColumns, FormatterMessages.CommentsTabPage_new_line_after_param_tags, "org.eclipse.php.formatter.core.formatter.comment.insert_new_line_for_parameter");
        this.nlParam.setIsChecked(this.codeFormatterPreferences.comment_insert_new_line_for_parameter);
        this.nlBoundariesJavadoc = this.createCheckboxPref((Composite)settingsGroup, numColumns, FormatterMessages.CommentsTabPage_new_lines_at_javadoc_boundaries);
        this.nlBoundariesJavadoc.setIsChecked(this.codeFormatterPreferences.comment_new_lines_at_javadoc_boundaries);
        this.blankLinesJavadoc = this.createCheckboxPref((Composite)settingsGroup, numColumns, FormatterMessages.CommentsTabPage_clear_blank_lines);
        this.blankLinesJavadoc.setIsChecked(this.codeFormatterPreferences.comment_clear_blank_lines_in_javadoc_comment);
        Group blockSettingsGroup = this.createGroup(numColumns, composite, FormatterMessages.CommentsTabPage_group4_title);
        this.nlBoundariesBlock = this.createCheckboxPref((Composite)blockSettingsGroup, numColumns, FormatterMessages.CommentsTabPage_new_lines_at_comment_boundaries);
        this.nlBoundariesBlock.setIsChecked(this.codeFormatterPreferences.comment_new_lines_at_block_boundaries);
        this.blankLinesBlock = this.createCheckboxPref((Composite)blockSettingsGroup, numColumns, FormatterMessages.CommentsTabPage_remove_blank_block_comment_lines);
        this.blankLinesBlock.setIsChecked(this.codeFormatterPreferences.comment_clear_blank_lines_in_block_comment);
        Group widthGroup = this.createGroup(numColumns, composite, FormatterMessages.CommentsTabPage_group3_title);
        this.lineWidth = this.createNumberPref((Composite)widthGroup, numColumns, FormatterMessages.CommentsTabPage_line_width, 0, 9999);
        this.lineWidth.setValue(this.codeFormatterPreferences.comment_line_length);
        ArrayList<ModifyDialogTabPage.CheckboxPreference> lineFirstColumnMasters = new ArrayList<ModifyDialogTabPage.CheckboxPreference>();
        lineFirstColumnMasters.add(this.singleLineComments);
        ArrayList<ModifyDialogTabPage.CheckboxPreference> lineFirstColumnSlaves = new ArrayList<ModifyDialogTabPage.CheckboxPreference>();
        lineFirstColumnSlaves.add(this.singleLineCommentsOnFirstColumn);
        new Controller(lineFirstColumnMasters, lineFirstColumnSlaves){

            @Override
            protected boolean areSlavesEnabled() {
                return CommentsTabPage.this.singleLineComments.isChecked();
            }
        }.update(null, null);
        ArrayList<ModifyDialogTabPage.CheckboxPreference> javaDocMaster = new ArrayList<ModifyDialogTabPage.CheckboxPreference>();
        javaDocMaster.add(this.javadoc);
        javaDocMaster.add(this.header);
        ArrayList<Object> javaDocSlaves = new ArrayList<Object>();
        javaDocSlaves.add(settingsGroup);
        javaDocSlaves.add(this.blankJavadoc);
        javaDocSlaves.add(this.indentJavadoc);
        javaDocSlaves.add(this.nlParam);
        javaDocSlaves.add(this.nlBoundariesJavadoc);
        javaDocSlaves.add(this.blankLinesJavadoc);
        new OrController(javaDocMaster, javaDocSlaves);
        ArrayList<ModifyDialogTabPage.CheckboxPreference> blankMasters = new ArrayList<ModifyDialogTabPage.CheckboxPreference>();
        blankMasters.add(this.javadoc);
        blankMasters.add(this.header);
        blankMasters.add(this.blankJavadoc);
        ArrayList<ModifyDialogTabPage.CheckboxPreference> blankSlaves = new ArrayList<ModifyDialogTabPage.CheckboxPreference>();
        blankSlaves.add(this.blankRootDesc);
        new Controller(blankMasters, blankSlaves){

            @Override
            protected boolean areSlavesEnabled() {
                return (CommentsTabPage.this.javadoc.isChecked() || CommentsTabPage.this.header.isChecked()) && CommentsTabPage.this.blankJavadoc.isChecked();
            }
        }.update(null, null);
        ArrayList<ModifyDialogTabPage.CheckboxPreference> indentMasters = new ArrayList<ModifyDialogTabPage.CheckboxPreference>();
        indentMasters.add(this.javadoc);
        indentMasters.add(this.header);
        indentMasters.add(this.indentJavadoc);
        ArrayList<ModifyDialogTabPage.CheckboxPreference> indentSlaves = new ArrayList<ModifyDialogTabPage.CheckboxPreference>();
        indentSlaves.add(this.indentDesc);
        new Controller(indentMasters, indentSlaves){

            @Override
            protected boolean areSlavesEnabled() {
                return (CommentsTabPage.this.javadoc.isChecked() || CommentsTabPage.this.header.isChecked()) && CommentsTabPage.this.indentJavadoc.isChecked();
            }
        }.update(null, null);
        ArrayList<ModifyDialogTabPage.CheckboxPreference> blockMasters = new ArrayList<ModifyDialogTabPage.CheckboxPreference>();
        blockMasters.add(this.blockComment);
        blockMasters.add(this.header);
        ArrayList<Object> blockSlaves = new ArrayList<Object>();
        blockSlaves.add(blockSettingsGroup);
        blockSlaves.add(this.nlBoundariesBlock);
        blockSlaves.add(this.blankLinesBlock);
        new OrController(blockMasters, blockSlaves);
        ArrayList<ModifyDialogTabPage.CheckboxPreference> lineWidthMasters = new ArrayList<ModifyDialogTabPage.CheckboxPreference>();
        lineWidthMasters.add(this.javadoc);
        lineWidthMasters.add(this.blockComment);
        lineWidthMasters.add(this.singleLineComments);
        lineWidthMasters.add(this.header);
        ArrayList<Object> lineWidthSlaves = new ArrayList<Object>();
        lineWidthSlaves.add(widthGroup);
        lineWidthSlaves.add(this.lineWidth);
        new OrController(lineWidthMasters, lineWidthSlaves);
        this.isInitialized = true;
    }

    @Override
    protected void initializePage() {
        this.fPreview.setPreviewText(this.PREVIEW);
    }

    @Override
    protected PHPPreview doCreatePHPPreview(Composite parent) {
        this.fPreview = new CodeFormatterPreview(this.codeFormatterPreferences, parent);
        return this.fPreview;
    }

    @Override
    protected void doUpdatePreview() {
        if (this.fPreview != null) {
            this.fPreview.update();
        }
    }

    private ModifyDialogTabPage.CheckboxPreference createPrefInsert(Composite composite, int numColumns, String text, String key) {
        return this.createCheckboxPref(composite, numColumns, text);
    }

    @Override
    protected void updatePreferences() {
        if (this.isInitialized) {
            this.codeFormatterPreferences.comment_format_javadoc_comment = this.javadoc.isChecked();
            this.codeFormatterPreferences.comment_format_block_comment = this.blockComment.isChecked();
            this.codeFormatterPreferences.comment_format_line_comment = this.singleLineComments.isChecked();
            this.codeFormatterPreferences.comment_format_line_comment_starting_on_first_column = this.singleLineCommentsOnFirstColumn.isChecked();
            this.codeFormatterPreferences.comment_format_header = this.header.isChecked();
            this.codeFormatterPreferences.never_indent_line_comments_on_first_column = this.chkbox2.isChecked();
            this.codeFormatterPreferences.never_indent_block_comments_on_first_column = this.chkbox3.isChecked();
            this.codeFormatterPreferences.join_lines_in_comments = this.chkbox4.isChecked();
            this.codeFormatterPreferences.comment_insert_empty_line_before_root_tags = this.blankJavadoc.isChecked();
            this.codeFormatterPreferences.comment_keep_empty_line_for_empty_description = this.blankRootDesc.isChecked();
            this.codeFormatterPreferences.comment_indent_root_tags = this.indentJavadoc.isChecked();
            this.codeFormatterPreferences.comment_indent_parameter_description = this.indentDesc.isChecked();
            this.codeFormatterPreferences.comment_never_format_unknown_tags = this.nerverFormatUnknownTags.isChecked();
            this.codeFormatterPreferences.comment_insert_new_line_for_parameter = this.nlParam.isChecked();
            this.codeFormatterPreferences.comment_new_lines_at_javadoc_boundaries = this.nlBoundariesJavadoc.isChecked();
            this.codeFormatterPreferences.comment_clear_blank_lines_in_javadoc_comment = this.blankLinesJavadoc.isChecked();
            this.codeFormatterPreferences.comment_new_lines_at_block_boundaries = this.nlBoundariesBlock.isChecked();
            this.codeFormatterPreferences.comment_clear_blank_lines_in_block_comment = this.blankLinesBlock.isChecked();
            this.codeFormatterPreferences.comment_line_length = this.lineWidth.getValue();
        }
    }

    private static abstract class Controller
    implements Observer {
        private final Collection<ModifyDialogTabPage.CheckboxPreference> fMasters;
        private final Collection<Object> fSlaves;

        public Controller(Collection<ModifyDialogTabPage.CheckboxPreference> masters, Collection<Object> slaves) {
            this.fMasters = masters;
            this.fSlaves = slaves;
            Iterator<ModifyDialogTabPage.CheckboxPreference> iter = this.fMasters.iterator();
            while (iter.hasNext()) {
                iter.next().addObserver(this);
            }
        }

        @Override
        public void update(Observable o, Object arg) {
            boolean enabled = this.areSlavesEnabled();
            for (Object obj : this.fSlaves) {
                if (obj instanceof ModifyDialogTabPage.CheckboxPreference) {
                    ((ModifyDialogTabPage.CheckboxPreference)obj).setEnabled(enabled);
                    continue;
                }
                if (!(obj instanceof Control)) continue;
                ((Group)obj).setEnabled(enabled);
            }
        }

        public Collection<ModifyDialogTabPage.CheckboxPreference> getMasters() {
            return this.fMasters;
        }

        protected abstract boolean areSlavesEnabled();
    }

    private static final class OrController
    extends Controller {
        public OrController(Collection<ModifyDialogTabPage.CheckboxPreference> masters, Collection<Object> slaves) {
            super(masters, slaves);
            this.update(null, null);
        }

        @Override
        protected boolean areSlavesEnabled() {
            Iterator<ModifyDialogTabPage.CheckboxPreference> iter = this.getMasters().iterator();
            while (iter.hasNext()) {
                if (!iter.next().isChecked()) continue;
                return true;
            }
            return false;
        }
    }
}

