/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.runtime.evaluation;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.evaluation.AbstractModelManager;
import org.eclipse.ocl.pivot.evaluation.ModelManager;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.internal.library.executor.ExecutorManager;
import org.eclipse.ocl.pivot.internal.utilities.PivotUtilInternal;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.MetamodelManager;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.qvtd.runtime.evaluation.IterableAsSet;
import org.eclipse.qvtd.runtime.evaluation.ModelsManager;
import org.eclipse.qvtd.runtime.evaluation.TransformationExecutor;
import org.eclipse.qvtd.runtime.evaluation.Transformer;
import org.eclipse.qvtd.runtime.evaluation.TypedModelInstance;
import org.eclipse.qvtd.runtime.internal.evaluation.AbstractTransformerInternal;
import org.eclipse.qvtd.runtime.qvttrace.TransformationExecution;

public abstract class AbstractTransformationExecutor
extends ExecutorManager
implements TransformationExecutor {
    protected final @NonNull EnvironmentFactory environmentFactory;
    protected final @NonNull Transformer transformer;
    private ModelManager model2Model0Manager = null;
    protected boolean suppressFailureDiagnosis = false;

    private AbstractTransformationExecutor(@NonNull EnvironmentFactory environmentFactory, @NonNull Constructor<? extends Transformer> txConstructor) throws ReflectiveOperationException {
        super(environmentFactory.getCompleteEnvironment());
        this.environmentFactory = environmentFactory;
        this.transformer = (Transformer)ClassUtil.nonNullState((Object)txConstructor.newInstance(this));
    }

    protected AbstractTransformationExecutor(@NonNull EnvironmentFactory environmentFactory, @NonNull java.lang.Class<? extends Transformer> txClass) throws ReflectiveOperationException {
        this(environmentFactory, (Constructor)ClassUtil.nonNullState(txClass.getConstructor(TransformationExecutor.class)));
    }

    @Override
    public @Nullable Resource addInputURI(@NonNull String modelName, @NonNull URI modelURI) {
        ResourceSet resourceSet = this.environmentFactory.getResourceSet();
        PivotUtil.initializeLoadOptionsToSupportSelfReferences((ResourceSet)resourceSet);
        Resource inputResource = (Resource)ClassUtil.nonNullState((Object)resourceSet.getResource(modelURI, true));
        TypedModelInstance typedModelInstance = this.getTypedModelInstance(modelName);
        typedModelInstance.addInputResource(inputResource);
        return inputResource;
    }

    @Override
    public @NonNull Resource addOutputURI(@NonNull String modelName, @NonNull URI modelURI) {
        ResourceSet resourceSet = PivotUtilInternal.isASURI((URI)modelURI) ? this.environmentFactory.getMetamodelManager().getASResourceSet() : this.environmentFactory.getResourceSet();
        TypedModelInstance typedModelInstance = this.getTypedModelInstance(modelName);
        Resource outputResource = (Resource)ClassUtil.nonNullState((Object)resourceSet.createResource(modelURI));
        typedModelInstance.addOutputResource(outputResource);
        return outputResource;
    }

    @Override
    public final Boolean execute(@Nullable String targetName) throws Exception {
        this.transformer.analyzeInputResources();
        if (targetName != null ? this.transformer.run(targetName) : this.transformer.run()) {
            return Boolean.TRUE;
        }
        if (!this.suppressFailureDiagnosis) {
            StringBuilder s = new StringBuilder();
            this.transformer.getInvocationManager().diagnoseWorkLists(s);
            throw new Exception("Failed to execute" + s.toString());
        }
        return Boolean.FALSE;
    }

    public @NonNull EnvironmentFactory getEnvironmentFactory() {
        return this.environmentFactory;
    }

    public @NonNull IdResolver getIdResolver() {
        return this.environmentFactory.getIdResolver();
    }

    public @NonNull MetamodelManager getMetamodelManager() {
        return this.environmentFactory.getMetamodelManager();
    }

    public @NonNull ModelManager getModelManager() {
        Object model2Model0Manager2 = this.model2Model0Manager;
        if (model2Model0Manager2 == null) {
            model2Model0Manager2 = this.model2Model0Manager = new Model2Model0Manager();
        }
        return model2Model0Manager2;
    }

    @Override
    public @NonNull ModelsManager getModelsManager() {
        return this.transformer.getModelsManager();
    }

    @Override
    public @NonNull Transformer getTransformer() {
        return this.transformer;
    }

    @Override
    public int getTypedModelIndex(@NonNull String targetModelName) {
        return this.transformer.getTypedModelIndex(targetModelName);
    }

    @Override
    public @NonNull TypedModelInstance getTypedModelInstance(@NonNull String modelName) {
        return this.transformer.getTypedModelInstance(modelName);
    }

    @Override
    public @Nullable TransformationExecution getTransformationExecution() {
        return this.transformer.getTransformationExecution();
    }

    @Override
    public void saveModels(@Nullable Map<?, ?> saveOptions) throws IOException {
        this.getModelsManager().saveModels(saveOptions);
    }

    @Override
    public void setContextualProperty(@NonNull String propertyName, Object value) {
        TransformationExecution txInstance = this.getTransformationExecution();
        if (txInstance == null) {
            throw new IllegalArgumentException("No contextual instance available");
        }
        EClass txEClass = txInstance.eClass();
        EStructuralFeature eStructuralFeature = txEClass.getEStructuralFeature(propertyName);
        if (eStructuralFeature == null) {
            throw new IllegalArgumentException("No '" + propertyName + "' contextual property in '" + txEClass.getName());
        }
        txInstance.eSet(eStructuralFeature, value);
    }

    @Override
    public void setSuppressFailureDiagnosis(boolean suppressFailureDiagnosis) {
        this.suppressFailureDiagnosis = suppressFailureDiagnosis;
    }

    private class Model2Model0Manager
    extends AbstractModelManager
    implements ModelManager.ModelManagerExtension2 {
        private Model2Model0Manager() {
        }

        public @NonNull Set<@NonNull ? extends Object> get(@NonNull Class type) {
            return new IterableAsSet<Object>(((AbstractTransformerInternal)AbstractTransformationExecutor.this.transformer).get(type));
        }

        public @NonNull Iterable<@NonNull Object> getOpposite(@NonNull Property target2sourceProperty, @NonNull Object sourceObject) {
            throw new UnsupportedOperationException();
        }
    }
}

