/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.widgets.Display;

public class Resources {
    public static final String DEFAULT_FONT_NAME = "Verdana";
    public static final int LARGE_FONT_SIZE = 13;
    public static final int MEDIUM_FONT_SIZE = 11;
    public static final int SMALL_FONT_SIZE = 9;
    public static final String RGB_DELIMITER = ",";
    private static final Map<RGB, Color> colorMap = new HashMap<RGB, Color>();
    private static final Map<String, Font> fontMap = new HashMap<String, Font>();
    private static final Map<String, TextLayout> textLayoutMap = new HashMap<String, TextLayout>();

    protected Resources() {
    }

    public static Color getColorDefault() {
        return Resources.getDisplay().getSystemColor(3);
    }

    public static Color getColor(String color) {
        String[] values;
        if (color != null && !color.isEmpty() && (values = color.split(RGB_DELIMITER)).length == 3) {
            int red = Integer.parseInt(values[0]);
            int green = Integer.parseInt(values[1]);
            int blue = Integer.parseInt(values[2]);
            return Resources.getColor(new RGB(red, green, blue));
        }
        return Resources.getColorDefault();
    }

    public static String getColor(Color color) {
        if (color == null) {
            color = Resources.getColorDefault();
        }
        StringBuilder builder = new StringBuilder();
        builder.append(color.getRed());
        builder.append(RGB_DELIMITER);
        builder.append(color.getGreen());
        builder.append(RGB_DELIMITER);
        builder.append(color.getBlue());
        return builder.toString();
    }

    public static Color getColor(RGB rgb) {
        Color color = colorMap.get(rgb);
        if (color == null) {
            color = new Color((Device)Resources.getDisplay(), rgb);
            colorMap.put(rgb, color);
        }
        return color;
    }

    public static Color getColor(int red, int green, int blue) {
        RGB rgb = new RGB(red, green, blue);
        return Resources.getColor(rgb);
    }

    public static Font getFont(FontData fontData) {
        return Resources.getFont(fontData.getName(), fontData.getHeight(), fontData.getStyle());
    }

    public static Font getFont(String name, int height, int style) {
        String key = Resources.getFontKey(name, height, style);
        Font font = fontMap.get(key);
        if (font == null) {
            font = new Font((Device)Resources.getDisplay(), name, height, style);
            fontMap.put(key, font);
        }
        return font;
    }

    public static TextLayout getTextLayout(String uuid) {
        TextLayout textLayout = textLayoutMap.get(uuid);
        if (textLayout == null) {
            textLayout = new TextLayout((Device)Resources.getDisplay());
            textLayoutMap.put(uuid, textLayout);
        }
        return textLayout;
    }

    protected void finalize() throws Throwable {
        for (Color color : colorMap.values()) {
            if (color == null || color.isDisposed()) continue;
            color.dispose();
        }
        for (Font font : fontMap.values()) {
            if (font == null || font.isDisposed()) continue;
            font.dispose();
        }
        for (TextLayout textLayout : textLayoutMap.values()) {
            if (textLayout == null || textLayout.isDisposed()) continue;
            textLayout.dispose();
        }
    }

    private static String getFontKey(String name, int height, int style) {
        StringBuilder builder = new StringBuilder();
        builder.append(name);
        builder.append("_");
        builder.append(height);
        builder.append("_");
        builder.append(style);
        return builder.toString();
    }

    protected static Display getDisplay() {
        return Display.getDefault();
    }
}

