/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.uml.internal.operations;

import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.internal.operations.ValueSpecificationOperations;

public class OpaqueExpressionOperations
extends ValueSpecificationOperations {
    protected OpaqueExpressionOperations() {
    }

    public static boolean validateLanguageBodySize(OpaqueExpression opaqueExpression, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public static boolean validateOnlyReturnResultParameters(OpaqueExpression opaqueExpression, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public static boolean validateOneReturnResultParameter(OpaqueExpression opaqueExpression, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public static int value(OpaqueExpression opaqueExpression) {
        for (String body : opaqueExpression.getBodies()) {
            try {
                return Integer.parseInt(body);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new UnsupportedOperationException();
    }

    public static boolean isIntegral(OpaqueExpression opaqueExpression) {
        for (String body : opaqueExpression.getBodies()) {
            try {
                Integer.parseInt(body);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isPositive(OpaqueExpression opaqueExpression) {
        for (String body : opaqueExpression.getBodies()) {
            try {
                return Integer.parseInt(body) > 0;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new UnsupportedOperationException();
    }

    public static boolean isNonNegative(OpaqueExpression opaqueExpression) {
        for (String body : opaqueExpression.getBodies()) {
            try {
                return Integer.parseInt(body) >= 0;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new UnsupportedOperationException();
    }

    public static Parameter getResult(OpaqueExpression opaqueExpression) {
        Behavior behavior = opaqueExpression.getBehavior();
        if (behavior != null) {
            for (Parameter ownedParameter : behavior.getOwnedParameters()) {
                if (ownedParameter.getDirection() != ParameterDirectionKind.RETURN_LITERAL) continue;
                return ownedParameter;
            }
        }
        return null;
    }

    public static String stringValue(OpaqueExpression opaqueExpression) {
        EList<String> bodies = opaqueExpression.getBodies();
        return bodies.size() > 0 ? (String)bodies.get(0) : ValueSpecificationOperations.stringValue(opaqueExpression);
    }
}

