/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.reflect;

import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.wb.internal.core.utils.reflect.IClassLoaderInitializer;

public class ClassLoaderLocalMap {
    private static final Object NULL_OBJECT = new Object();
    private static final Map<Object, Map<Object, Object>> globalMap = Collections.synchronizedMap(new WeakHashMap());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean containsKey(ClassLoader cl, Object key) {
        Object object = NULL_OBJECT;
        synchronized (object) {
            return ClassLoaderLocalMap.getLocalMap(cl).containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void put(ClassLoader cl, Object key, Object value) {
        Object object = NULL_OBJECT;
        synchronized (object) {
            ClassLoaderLocalMap.getLocalMap(cl).put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object get(ClassLoader cl, Object key) {
        Object object = NULL_OBJECT;
        synchronized (object) {
            return ClassLoaderLocalMap.getLocalMap(cl).get(key);
        }
    }

    private static Map<Object, Object> getLocalMap(ClassLoader key) {
        Object gkey = key;
        if (gkey == null) {
            gkey = NULL_OBJECT;
        }
        return globalMap.computeIfAbsent(gkey, ignore -> new WeakHashMap());
    }

    public static class ClassLoaderLocalMapManager
    implements IClassLoaderInitializer {
        @Override
        public void initialize(ClassLoader classLoader) {
        }

        @Override
        public void deinitialize(ClassLoader classLoader) {
            globalMap.clear();
        }
    }
}

