/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.MigLayout.model.ui;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.ui.GridDataFactory;
import org.eclipse.wb.internal.core.utils.ui.GridLayoutFactory;
import org.eclipse.wb.internal.core.utils.ui.dialogs.ResizableDialog;
import org.eclipse.wb.internal.swing.MigLayout.Activator;
import org.eclipse.wb.internal.swing.MigLayout.model.CellConstraintsSupport;
import org.eclipse.wb.internal.swing.MigLayout.model.MigLayoutInfo;
import org.eclipse.wb.internal.swing.MigLayout.model.ModelMessages;
import org.eclipse.wb.internal.swing.MigLayout.model.ui.CellSpecificationComposite;

public final class CellEditDialog
extends ResizableDialog {
    private final MigLayoutInfo m_layout;
    private final CellConstraintsSupport m_cell;
    private final String m_cellString;
    private CellSpecificationComposite m_specificationComposite;

    public CellEditDialog(Shell parentShell, MigLayoutInfo layout, CellConstraintsSupport cell) {
        super(parentShell, (AbstractUIPlugin)Activator.getDefault());
        this.setShellStyle(67680);
        this.m_layout = layout;
        this.m_cell = cell;
        this.m_cellString = this.m_cell.getString();
    }

    public void create() {
        super.create();
        this.showCell();
        this.m_specificationComposite.setFocus();
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        this.createHeaderComposite(container);
        return container;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(ModelMessages.CellEditDialog_cellProperties);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.commitChanges();
        }
        if (buttonId == 1) {
            this.rollbackChanges();
        }
        super.buttonPressed(buttonId);
    }

    private void updateButtons(boolean valid) {
        this.getButton(0).setEnabled(valid);
    }

    private void commitChanges() {
        ExecutionUtils.run((ObjectInfo)this.m_layout, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                CellEditDialog.this.m_cell.write();
            }
        });
    }

    private void rollbackChanges() {
        ExecutionUtils.runLog((RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                CellEditDialog.this.m_cell.setString(CellEditDialog.this.m_cellString);
            }
        });
    }

    private void createHeaderComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridDataFactory.create((Control)composite).grabH().fill();
        GridLayoutFactory.create((Composite)composite).noMargins().columns(4);
        new Label(composite, 0).setText(ModelMessages.CellEditDialog_specification);
        this.m_specificationComposite = new CellSpecificationComposite(composite);
        GridDataFactory.create((Control)this.m_specificationComposite).spanH(3).indentHC(3).hintHC(30);
        this.m_specificationComposite.addListener(24, new Listener(){

            public void handleEvent(Event e) {
                CellEditDialog.this.updateButtons(e.doit);
                CellEditDialog.this.showCell();
            }
        });
    }

    private void showCell() {
        this.m_specificationComposite.fromCell(this.m_cell);
    }
}

