/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.ui.liveedit;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.jsdt.chromium.TextStreamPosition;
import org.eclipse.wst.jsdt.chromium.UpdatableScript;
import org.eclipse.wst.jsdt.chromium.debug.core.ChromiumDebugPlugin;
import org.eclipse.wst.jsdt.chromium.debug.core.model.PushChangesPlan;
import org.eclipse.wst.jsdt.chromium.debug.core.util.ScriptTargetMapping;
import org.eclipse.wst.jsdt.chromium.debug.ui.DialogUtils;
import org.eclipse.wst.jsdt.chromium.debug.ui.WizardUtils;
import org.eclipse.wst.jsdt.chromium.debug.ui.actions.ChooseVmControl;
import org.eclipse.wst.jsdt.chromium.debug.ui.liveedit.LiveEditDiffViewer;
import org.eclipse.wst.jsdt.chromium.debug.ui.liveedit.LiveEditResultDialog;
import org.eclipse.wst.jsdt.chromium.debug.ui.liveedit.Messages;
import org.eclipse.wst.jsdt.chromium.debug.ui.liveedit.PreviewLoader;
import org.eclipse.wst.jsdt.chromium.debug.ui.liveedit.PushChangesWizard;
import org.eclipse.wst.jsdt.chromium.debug.ui.liveedit.PushResultParser;

class WizardLogicBuilder {
    private final DialogUtils.Updater updater;
    private final PushChangesWizard.PageSet pageSet;
    private final WizardUtils.LogicBasedWizard wizardImpl;

    WizardLogicBuilder(PushChangesWizard.PageSet pageSet, WizardUtils.LogicBasedWizard wizardImpl) {
        this.pageSet = pageSet;
        this.wizardImpl = wizardImpl;
        this.updater = new DialogUtils.Updater();
    }

    WizardUtils.WizardLogic create(List<? extends ScriptTargetMapping> targetList, final LiveEditResultDialog.ErrorPositionHighlighter positionHighlighter) {
        DialogUtils.Scope scope = this.updater.rootScope();
        final WizardUtils.PageImpl<PushChangesWizard.ChooseVmPageElements> chooseVmPage = this.pageSet.getChooseVmPage();
        final DialogUtils.ValueSource<List<ScriptTargetMapping>> selectedVmInput = new DialogUtils.ValueSource<List<ScriptTargetMapping>>(chooseVmPage, targetList){
            private final ChooseVmControl.Logic chooseVmControl;
            {
                this.chooseVmControl = ((PushChangesWizard.ChooseVmPageElements)pageImpl.getPageElements()).getChooseVm();
                this.chooseVmControl.setData(list);
                this.chooseVmControl.selectAll();
                final 1 thisSource = this;
                ChooseVmControl.Logic.Listener listener = new ChooseVmControl.Logic.Listener(){

                    @Override
                    public void checkStateChanged() {
                        WizardLogicBuilder.this.updater.reportChanged(thisSource);
                        WizardLogicBuilder.this.updater.update();
                    }
                };
                this.chooseVmControl.addListener(listener);
            }

            @Override
            public List<ScriptTargetMapping> getValue() {
                return this.chooseVmControl.getSelected();
            }
        };
        this.updater.addSource(scope, selectedVmInput);
        final DialogUtils.ValueProcessor<List<DialogUtils.Optional<PushChangesPlan>>> selectedChangePlansValue = DialogUtils.createProcessor(new DialogUtils.Gettable<List<DialogUtils.Optional<PushChangesPlan>>>(){

            @Override
            public List<DialogUtils.Optional<PushChangesPlan>> getValue() {
                List input = (List)selectedVmInput.getValue();
                ArrayList<DialogUtils.Optional<PushChangesPlan>> result = new ArrayList<DialogUtils.Optional<PushChangesPlan>>(input.size());
                for (ScriptTargetMapping mapping : input) {
                    DialogUtils.Optional<Object> optionalPlan;
                    try {
                        PushChangesPlan plan = PushChangesPlan.create((ScriptTargetMapping)mapping);
                        optionalPlan = DialogUtils.createOptional(plan);
                    }
                    catch (RuntimeException runtimeException) {
                        optionalPlan = DialogUtils.createErrorOptional(new DialogUtils.Message(Messages.WizardLogicBuilder_FAILED_TO_GET, DialogUtils.MessagePriority.BLOCKING_PROBLEM));
                    }
                    result.add(optionalPlan);
                }
                return result;
            }
        });
        this.updater.addSource(scope, selectedChangePlansValue);
        this.updater.addConsumer(scope, selectedChangePlansValue);
        this.updater.addDependency(selectedChangePlansValue, selectedVmInput);
        final DialogUtils.ValueProcessor<DialogUtils.Optional<List<PushChangesPlan>>> nonEmptySelectedPlansValue = DialogUtils.createProcessor(new DialogUtils.Gettable<DialogUtils.Optional<List<PushChangesPlan>>>(){

            @Override
            public DialogUtils.Optional<List<PushChangesPlan>> getValue() {
                List planList = (List)selectedChangePlansValue.getValue();
                if (planList.isEmpty()) {
                    return DialogUtils.createErrorOptional(new DialogUtils.Message(Messages.WizardLogicBuilder_CHOOSE_VM, DialogUtils.MessagePriority.BLOCKING_INFO));
                }
                LinkedList<DialogUtils.Message> errorMessages = new LinkedList<DialogUtils.Message>();
                ArrayList<PushChangesPlan> result = new ArrayList<PushChangesPlan>(planList.size());
                for (DialogUtils.Optional optionalPlan : planList) {
                    if (optionalPlan.isNormal()) {
                        result.add((PushChangesPlan)optionalPlan.getNormal());
                        continue;
                    }
                    errorMessages.addAll(optionalPlan.errorMessages());
                }
                if (errorMessages.isEmpty()) {
                    return DialogUtils.createOptional(result);
                }
                return DialogUtils.createErrorOptional(new HashSet(errorMessages));
            }
        });
        this.updater.addSource(scope, nonEmptySelectedPlansValue);
        this.updater.addConsumer(scope, nonEmptySelectedPlansValue);
        this.updater.addDependency(nonEmptySelectedPlansValue, selectedChangePlansValue);
        DialogUtils.Gettable<DialogUtils.Optional<Boolean>> singleVmSelectedExpression = DialogUtils.handleErrors(new DialogUtils.NormalExpression<Boolean>(){

            @DialogUtils.NormalExpression.Calculate
            public Boolean calculate(List<PushChangesPlan> selectedVm) {
                if (selectedVm.size() == 1) {
                    return true;
                }
                return false;
            }

            @DialogUtils.NormalExpression.DependencyGetter
            public DialogUtils.ValueSource<? extends DialogUtils.Optional<List<PushChangesPlan>>> getSelectVmSource() {
                return nonEmptySelectedPlansValue;
            }
        });
        DialogUtils.OptionalSwitcher<Boolean> singleVmSelectedSwitch = scope.addOptionalSwitch(singleVmSelectedExpression);
        PreviewAndOptionPath singleVmPath = this.createSingleVmPath(chooseVmPage, singleVmSelectedSwitch, nonEmptySelectedPlansValue);
        PreviewAndOptionPath multipleVmPath = this.createMultipleVmPath(chooseVmPage, singleVmSelectedSwitch, nonEmptySelectedPlansValue);
        final PreviewAndOptionPath switchBlockItems = DialogUtils.mergeBranchVariables(PreviewAndOptionPath.class, singleVmSelectedSwitch, singleVmPath, multipleVmPath);
        DialogUtils.ValueProcessor<DialogUtils.Optional<WizardUtils.WizardFinisher>> finisherValue = DialogUtils.createProcessor(DialogUtils.handleErrors(new DialogUtils.NormalExpression<WizardUtils.WizardFinisher>(){

            @DialogUtils.NormalExpression.Calculate
            public WizardUtils.WizardFinisher calculate(PushChangesWizard.FinisherDelegate finisherDelegate) {
                return new PushChangesWizard.FinisherImpl(finisherDelegate, positionHighlighter);
            }

            @DialogUtils.NormalExpression.DependencyGetter
            public DialogUtils.ValueSource<? extends DialogUtils.Optional<? extends PushChangesWizard.FinisherDelegate>> getWizardFinisherDelegateSource() {
                return switchBlockItems.getFinisherDelegateValue();
            }
        }));
        this.updater.addConsumer(scope, finisherValue);
        this.updater.addSource(scope, finisherValue);
        this.updater.addDependency(finisherValue, switchBlockItems.getFinisherDelegateValue());
        WizardUtils.WizardFinishController finishController = new WizardUtils.WizardFinishController(finisherValue, switchBlockItems.getWarningValue(), this.wizardImpl);
        this.updater.addConsumer(scope, finishController);
        this.updater.addDependency((DialogUtils.ValueConsumer)finishController, switchBlockItems.getFinisherDelegateValue());
        this.updater.addDependency((DialogUtils.ValueConsumer)finishController, switchBlockItems.getWarningValue());
        return new WizardUtils.WizardLogic(){

            @Override
            public void updateAll() {
                WizardLogicBuilder.this.updater.updateAll();
            }

            @Override
            public WizardUtils.PageImpl<?> getStartingPage() {
                return chooseVmPage;
            }

            @Override
            public void dispose() {
                WizardLogicBuilder.this.updater.stopAsync();
            }
        };
    }

    private PreviewAndOptionPath createSingleVmPath(WizardUtils.PageImpl<?> basePage, DialogUtils.OptionalSwitcher<Boolean> switcher, final DialogUtils.ValueSource<? extends DialogUtils.Optional<? extends List<PushChangesPlan>>> selectedVmValue) {
        final WizardUtils.PageImpl<PushChangesWizard.V8PreviewPageElements> v8PreviewPage = this.pageSet.getV8PreviewPage();
        WizardUtils.NextPageEnabler scopeEnabler = new WizardUtils.NextPageEnabler(basePage, v8PreviewPage);
        DialogUtils.Scope scope = switcher.addScope(Boolean.TRUE, scopeEnabler);
        final DialogUtils.ValueProcessor<PushChangesPlan> singlePlanValue = DialogUtils.createProcessor(new DialogUtils.Gettable<PushChangesPlan>(){

            @Override
            public PushChangesPlan getValue() {
                return (PushChangesPlan)((List)((DialogUtils.Optional)selectedVmValue.getValue()).getNormal()).get(0);
            }
        });
        this.updater.addConsumer(scope, singlePlanValue);
        this.updater.addSource(scope, singlePlanValue);
        this.updater.addDependency(singlePlanValue, selectedVmValue);
        final PreviewLoader previewRawResultValue = new PreviewLoader(this.updater, singlePlanValue);
        previewRawResultValue.registerSelf(scope);
        v8PreviewPage.addListener(new WizardUtils.PageListener(){

            @Override
            public void onSetVisible(boolean visible) {
                previewRawResultValue.setActive(visible);
            }
        });
        final DialogUtils.ValueProcessor<DialogUtils.Optional<LiveEditDiffViewer.Input>> previewValue = DialogUtils.createProcessor(DialogUtils.handleErrors(new DialogUtils.NormalExpression<LiveEditDiffViewer.Input>(){

            @DialogUtils.NormalExpression.Calculate
            public DialogUtils.Optional<? extends LiveEditDiffViewer.Input> calculate(PreviewLoader.Data previewRawResultParam) {
                final PushChangesPlan changesPlan = (PushChangesPlan)singlePlanValue.getValue();
                return previewRawResultParam.accept(new PreviewLoader.Data.Visitor<DialogUtils.Optional<LiveEditDiffViewer.Input>>(){

                    @Override
                    public DialogUtils.Optional<LiveEditDiffViewer.Input> visitSuccess(UpdatableScript.ChangeDescription changeDescription) {
                        if (changeDescription == null) {
                            return DialogUtils.createOptional(null);
                        }
                        try {
                            LiveEditDiffViewer.Input viewerInput = PushResultParser.createViewerInput(changeDescription, changesPlan, true);
                            return DialogUtils.createOptional(viewerInput);
                        }
                        catch (RuntimeException e) {
                            ChromiumDebugPlugin.log((Throwable)e);
                            String messageText = NLS.bind((String)Messages.WizardLogicBuilder_ERROR_GETTING_PREVIEW, (Object)e.toString());
                            return DialogUtils.createErrorOptional(new DialogUtils.Message(messageText, DialogUtils.MessagePriority.WARNING));
                        }
                    }

                    @Override
                    public DialogUtils.Optional<LiveEditDiffViewer.Input> visitCompileError(UpdatableScript.CompileErrorFailure compileError) {
                        LiveEditDiffViewer.Input viewerInput = PushResultParser.createCompileErrorViewerInput(compileError, changesPlan, true);
                        return DialogUtils.createOptional(viewerInput);
                    }
                });
            }

            @DialogUtils.NormalExpression.DependencyGetter
            public DialogUtils.ValueSource<DialogUtils.Optional<PreviewLoader.Data>> previewRawResultValueSource() {
                return previewRawResultValue;
            }
        }));
        this.updater.addConsumer(scope, previewValue);
        this.updater.addSource(scope, previewValue);
        this.updater.addDependency(previewValue, previewRawResultValue);
        this.updater.addDependency(previewValue, singlePlanValue);
        DialogUtils.ValueConsumer v8PreviewInputSetter = new DialogUtils.ValueConsumer(){

            @Override
            public void update(DialogUtils.Updater updater) {
                DialogUtils.Optional previewOptional = (DialogUtils.Optional)previewValue.getValue();
                LiveEditDiffViewer.Input viewerInput = previewOptional.isNormal() ? (LiveEditDiffViewer.Input)previewOptional.getNormal() : null;
                ((PushChangesWizard.V8PreviewPageElements)v8PreviewPage.getPageElements()).getPreviewViewer().setInput(viewerInput);
            }
        };
        this.updater.addConsumer(scope, v8PreviewInputSetter);
        this.updater.addDependency(v8PreviewInputSetter, previewValue);
        final DialogUtils.ValueProcessor<DialogUtils.Optional<Void>> warningValue = DialogUtils.createProcessor(new DialogUtils.Gettable<DialogUtils.Optional<Void>>(){

            @Override
            public DialogUtils.Optional<Void> getValue() {
                Object previewResult = previewRawResultValue.getValue();
                if (previewResult.isNormal()) {
                    PreviewLoader.Data data = (PreviewLoader.Data)previewResult.getNormal();
                    return data.accept(new PreviewLoader.Data.Visitor<DialogUtils.Optional<Void>>(){

                        @Override
                        public DialogUtils.Optional<Void> visitSuccess(UpdatableScript.ChangeDescription changeDescription) {
                            return DialogUtils.createOptional(null);
                        }

                        @Override
                        public DialogUtils.Optional<Void> visitCompileError(UpdatableScript.CompileErrorFailure compileError) {
                            TextStreamPosition start = compileError.getStartPosition();
                            String messageString = NLS.bind((String)Messages.WizardLogicBuilder_COMPILE_ERROR_AT, (Object[])new Object[]{compileError.getCompilerMessage(), start.getLine(), start.getColumn()});
                            return DialogUtils.createErrorOptional(new DialogUtils.Message(messageString, DialogUtils.MessagePriority.BLOCKING_PROBLEM));
                        }
                    });
                }
                return DialogUtils.createErrorOptional(previewResult.errorMessages());
            }
        });
        this.updater.addConsumer(scope, warningValue);
        this.updater.addSource(scope, warningValue);
        this.updater.addDependency(warningValue, previewRawResultValue);
        final DialogUtils.ValueProcessor<DialogUtils.Optional<PushChangesWizard.FinisherDelegate>> wizardFinisher = DialogUtils.createProcessor(new DialogUtils.Gettable<DialogUtils.Optional<PushChangesWizard.FinisherDelegate>>(){

            @Override
            public DialogUtils.Optional<PushChangesWizard.FinisherDelegate> getValue() {
                PushChangesWizard.SingleVmFinisher finisher = new PushChangesWizard.SingleVmFinisher((PushChangesPlan)singlePlanValue.getValue());
                return DialogUtils.createOptional(finisher);
            }
        });
        this.updater.addSource(scope, wizardFinisher);
        this.updater.addConsumer(scope, wizardFinisher);
        this.updater.addDependency(wizardFinisher, singlePlanValue);
        return new PreviewAndOptionPath(){

            public DialogUtils.ValueSource<? extends DialogUtils.Optional<PushChangesWizard.FinisherDelegate>> getFinisherDelegateValue() {
                return wizardFinisher;
            }

            @Override
            public DialogUtils.ValueSource<DialogUtils.Optional<Void>> getWarningValue() {
                return warningValue;
            }
        };
    }

    private PreviewAndOptionPath createMultipleVmPath(WizardUtils.PageImpl<?> basePage, DialogUtils.OptionalSwitcher<Boolean> switcher, final DialogUtils.ValueSource<? extends DialogUtils.Optional<? extends List<PushChangesPlan>>> selectedVmValue) {
        WizardUtils.PageImpl<WizardUtils.PageElements> multipleVmStubPage = this.pageSet.getMultipleVmStubPage();
        WizardUtils.NextPageEnabler scopeEnabler = new WizardUtils.NextPageEnabler(basePage, multipleVmStubPage);
        DialogUtils.Scope scope = switcher.addScope(Boolean.FALSE, scopeEnabler);
        final DialogUtils.ValueProcessor<DialogUtils.Optional<PushChangesWizard.FinisherDelegate>> wizardFinisher = DialogUtils.createProcessor(DialogUtils.handleErrors(new DialogUtils.NormalExpression<PushChangesWizard.FinisherDelegate>(){

            @DialogUtils.NormalExpression.Calculate
            public PushChangesWizard.FinisherDelegate calculate(List<PushChangesPlan> selectedVm) {
                return new PushChangesWizard.MultipleVmFinisher((List)((DialogUtils.Optional)selectedVmValue.getValue()).getNormal());
            }

            @DialogUtils.NormalExpression.DependencyGetter
            public DialogUtils.ValueSource<? extends DialogUtils.Optional<? extends List<PushChangesPlan>>> getSelectVmSource() {
                return selectedVmValue;
            }
        }));
        this.updater.addSource(scope, wizardFinisher);
        this.updater.addConsumer(scope, wizardFinisher);
        this.updater.addDependency(wizardFinisher, selectedVmValue);
        final DialogUtils.ValueSource<DialogUtils.Optional<Object>> warningValue = DialogUtils.createConstant(DialogUtils.createOptional(null), this.updater);
        return new PreviewAndOptionPath(){

            @Override
            public DialogUtils.ValueSource<? extends DialogUtils.Optional<? extends PushChangesWizard.FinisherDelegate>> getFinisherDelegateValue() {
                return wizardFinisher;
            }

            @Override
            public DialogUtils.ValueSource<DialogUtils.Optional<Void>> getWarningValue() {
                return warningValue;
            }
        };
    }

    private static interface PreviewAndOptionPath {
        @DialogUtils.BranchVariableGetter
        public DialogUtils.ValueSource<? extends DialogUtils.Optional<? extends PushChangesWizard.FinisherDelegate>> getFinisherDelegateValue();

        @DialogUtils.BranchVariableGetter
        public DialogUtils.ValueSource<DialogUtils.Optional<Void>> getWarningValue();
    }
}

