/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal.wip;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.wst.jsdt.chromium.internal.BaseCommandProcessor;
import org.eclipse.wst.jsdt.chromium.internal.wip.protocol.input.WipCommandResponse;

public interface WipCommandCallback
extends BaseCommandProcessor.Callback<WipCommandResponse> {

    public static abstract class Default
    implements WipCommandCallback {
        protected abstract void onSuccess(WipCommandResponse.Success var1);

        protected abstract void onError(String var1);

        public void messageReceived(WipCommandResponse response) {
            WipCommandResponse.Success asSuccess = response.asSuccess();
            if (asSuccess != null) {
                this.onSuccess(asSuccess);
            } else {
                String message;
                WipCommandResponse.Error asError = response.asError();
                if (asError == null) {
                    message = "Internal messaging error";
                } else {
                    ArrayList<String> messageList = new ArrayList<String>(2);
                    messageList.add(asError.error().message());
                    List<String> data = asError.error().data();
                    if (data != null) {
                        messageList.addAll(data);
                    }
                    message = ((Object)messageList).toString();
                }
                this.onError(message);
            }
        }

        public void failure(String message) {
            this.onError(message);
        }
    }
}

