/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.ES6ModuleLoader;
import com.google.javascript.jscomp.Es6ToEs3Converter;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.ProcessCommonJSModules;
import com.google.javascript.jscomp.Var;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSDocInfoBuilder;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ProcessEs6Modules
extends NodeTraversal.AbstractPostOrderCallback {
    private static final String DEFAULT_EXPORT_NAME = "$jscompDefaultExport";
    static final DiagnosticType LHS_OF_GOOG_REQUIRE_MUST_BE_CONST = DiagnosticType.error("JSC_LHS_OF_GOOG_REQUIRE_MUST_BE_CONST", "The left side of a goog.require() must use ''const'' (not ''let'' or ''var'')");
    static final DiagnosticType USELESS_USE_STRICT_DIRECTIVE = DiagnosticType.warning("JSC_USELESS_USE_STRICT_DIRECTIVE", "'use strict' is unnecessary in ES6 modules.");
    static final DiagnosticType NAMESPACE_IMPORT_CANNOT_USE_STAR = DiagnosticType.error("JSC_NAMESPACE_IMPORT_CANNOT_USE_STAR", "Namespace imports ('goog:some.Namespace') cannot use import * as. Did you mean to import {0} from '{1}';?");
    private static final ImmutableSet<String> USE_STRICT_ONLY = ImmutableSet.of((Object)"use strict");
    private final ES6ModuleLoader loader;
    private final Compiler compiler;
    private int scriptNodeCount = 0;
    private Map<String, NameNodePair> exportMap = new LinkedHashMap<String, NameNodePair>();
    private Map<String, ModuleOriginalNamePair> importMap = new HashMap<String, ModuleOriginalNamePair>();
    private Set<String> classes = new HashSet<String>();
    private Set<String> typedefs = new HashSet<String>();
    private Set<String> alreadyRequired = new HashSet<String>();
    private boolean isEs6Module;
    private boolean reportDependencies;

    public ProcessEs6Modules(Compiler compiler, ES6ModuleLoader loader, boolean reportDependencies) {
        this.compiler = compiler;
        this.loader = loader;
        this.reportDependencies = reportDependencies;
    }

    public void processFile(Node root) {
        ProcessCommonJSModules.FindGoogProvideOrGoogModule finder = new ProcessCommonJSModules.FindGoogProvideOrGoogModule();
        NodeTraversal.traverseEs6(this.compiler, root, finder);
        if (finder.isFound()) {
            return;
        }
        this.isEs6Module = false;
        NodeTraversal.traverseEs6(this.compiler, root, this);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (n.isImport()) {
            this.isEs6Module = true;
            this.visitImport(t, n, parent);
        } else if (n.isExport()) {
            this.isEs6Module = true;
            this.visitExport(t, n, parent);
        } else if (n.isScript()) {
            ++this.scriptNodeCount;
            this.visitScript(t, n);
        }
    }

    private void visitImport(NodeTraversal t, Node importDecl, Node parent) {
        String moduleName;
        String importName = importDecl.getLastChild().getString();
        boolean isNamespaceImport = importName.startsWith("goog:");
        if (isNamespaceImport) {
            moduleName = importName.substring("goog:".length());
        } else {
            URI loadAddress = this.loader.locateEs6Module(importName, t.getInput());
            if (loadAddress == null) {
                this.compiler.report(t.makeError(importDecl, ES6ModuleLoader.LOAD_ERROR, importName));
                return;
            }
            moduleName = ES6ModuleLoader.toModuleName(loadAddress);
        }
        for (Node child : importDecl.children()) {
            if (child.isEmpty() || child.isString()) continue;
            if (child.isName()) {
                String name = isNamespaceImport ? "" : "default";
                this.importMap.put(child.getString(), new ModuleOriginalNamePair(moduleName, name));
                continue;
            }
            if (child.getType() == 166) {
                for (Node grandChild : child.children()) {
                    String origName = grandChild.getFirstChild().getString();
                    if (grandChild.getChildCount() == 2) {
                        this.importMap.put(grandChild.getLastChild().getString(), new ModuleOriginalNamePair(moduleName, origName));
                        continue;
                    }
                    this.importMap.put(origName, new ModuleOriginalNamePair(moduleName, origName));
                }
                continue;
            }
            Preconditions.checkState((child.getType() == 168 ? 1 : 0) != 0, (String)"Expected an IMPORT_STAR node, but was: %s", (Object[])new Object[]{child});
            if (isNamespaceImport) {
                this.compiler.report(t.makeError(importDecl, NAMESPACE_IMPORT_CANNOT_USE_STAR, child.getString(), moduleName));
            }
            this.importMap.put(child.getString(), new ModuleOriginalNamePair(moduleName, ""));
        }
        Node script = NodeUtil.getEnclosingScript(parent);
        if (this.alreadyRequired.add(moduleName)) {
            Node require = IR.exprResult(IR.call(NodeUtil.newQName(this.compiler, "goog.require"), IR.string(moduleName)));
            require.copyInformationFromForTree(importDecl);
            script.addChildToFront(require);
            if (this.reportDependencies) {
                t.getInput().addRequire(moduleName);
            }
        }
        parent.removeChild(importDecl);
        this.compiler.reportCodeChange();
    }

    private void visitExport(NodeTraversal t, Node export, Node parent) {
        if (export.getBooleanProp(62)) {
            Node child = export.getFirstChild();
            String name = null;
            if (child.isFunction() || child.isClass()) {
                name = NodeUtil.getName(child);
            }
            if (name != null) {
                Node decl = child.cloneTree();
                decl.setJSDocInfo(child.getJSDocInfo());
                parent.replaceChild(export, decl);
                this.exportMap.put("default", new NameNodePair(name, child));
            } else {
                Node var = IR.var(IR.name(DEFAULT_EXPORT_NAME), export.removeFirstChild());
                var.setJSDocInfo(child.getJSDocInfo());
                child.setJSDocInfo(null);
                var.useSourceInfoIfMissingFromForTree(export);
                parent.replaceChild(export, var);
                this.exportMap.put("default", new NameNodePair(DEFAULT_EXPORT_NAME, child));
            }
        } else if (export.getBooleanProp(63)) {
            this.compiler.report(JSError.make(export, Es6ToEs3Converter.CANNOT_CONVERT_YET, "Wildcard export"));
        } else if (export.getChildCount() == 2) {
            Node moduleIdentifier = export.getLastChild();
            Node importNode = new Node(165, moduleIdentifier.cloneNode());
            importNode.copyInformationFrom(export);
            parent.addChildBefore(importNode, export);
            this.visit(t, importNode, parent);
            URI loadAddress = this.loader.locateEs6Module(moduleIdentifier.getString(), t.getInput());
            if (loadAddress == null) {
                this.compiler.report(t.makeError(moduleIdentifier, ES6ModuleLoader.LOAD_ERROR, moduleIdentifier.getString()));
                return;
            }
            String moduleName = ES6ModuleLoader.toModuleName(loadAddress);
            for (Node exportSpec : export.getFirstChild().children()) {
                String nameFromOtherModule = exportSpec.getFirstChild().getString();
                String exportedName = exportSpec.getLastChild().getString();
                this.exportMap.put(exportedName, new NameNodePair(moduleName + "." + nameFromOtherModule, exportSpec));
            }
            parent.removeChild(export);
        } else {
            if (export.getFirstChild().getType() == 170) {
                for (Node exportSpec : export.getFirstChild().children()) {
                    Node origName = exportSpec.getFirstChild();
                    this.exportMap.put(exportSpec.getChildCount() == 2 ? exportSpec.getLastChild().getString() : origName.getString(), new NameNodePair(origName.getString(), exportSpec));
                }
                parent.removeChild(export);
            } else {
                Node maybeName;
                Node declaration = export.getFirstChild();
                for (int i = 0; i < declaration.getChildCount() && (maybeName = declaration.getChildAtIndex(i)).isName() && (!declaration.isClass() || i <= 0); ++i) {
                    String name = maybeName.getString();
                    Var v = t.getScope().getVar(name);
                    if (v == null || v.isGlobal()) {
                        this.exportMap.put(name, new NameNodePair(name, maybeName));
                    }
                    if (declaration.isClass()) {
                        this.classes.add(name);
                    }
                    if (declaration.getJSDocInfo() == null || !declaration.getJSDocInfo().hasTypedefType()) continue;
                    this.typedefs.add(name);
                }
                parent.replaceChild(export, declaration.detachFromParent());
            }
            this.compiler.reportCodeChange();
        }
    }

    private void visitScript(NodeTraversal t, Node script) {
        JSDocInfoBuilder jsDocInfo;
        if (!this.isEs6Module) {
            return;
        }
        ProcessEs6Modules.checkStrictModeDirective(t, script);
        Preconditions.checkArgument((this.scriptNodeCount == 1 ? 1 : 0) != 0, (Object)"ProcessEs6Modules supports only one invocation per CompilerInput / script node");
        this.rewriteRequires(script);
        URI normalizedAddress = this.loader.normalizeInputAddress(t.getInput());
        String moduleName = ES6ModuleLoader.toModuleName(normalizedAddress);
        for (Map.Entry<String, NameNodePair> entry : this.exportMap.entrySet()) {
            String exportedName = entry.getKey();
            String withSuffix = entry.getValue().name;
            Node nodeForSourceInfo = entry.getValue().nodeForSourceInfo;
            Node getProp = IR.getprop(IR.name(moduleName), IR.string(exportedName));
            if (this.typedefs.contains(exportedName)) {
                JSDocInfoBuilder builder = new JSDocInfoBuilder(true);
                JSTypeExpression typeExpr = new JSTypeExpression(IR.string(exportedName), script.getSourceFileName());
                builder.recordTypedef(typeExpr);
                JSDocInfo info = builder.build();
                getProp.setJSDocInfo(info);
                Node exprResult = IR.exprResult(getProp).useSourceInfoIfMissingFromForTree(nodeForSourceInfo);
                script.addChildToBack(exprResult);
                continue;
            }
            Node assign = IR.assign(getProp, NodeUtil.newQName(this.compiler, withSuffix));
            Node exprResult = IR.exprResult(assign).useSourceInfoIfMissingFromForTree(nodeForSourceInfo);
            if (this.classes.contains(exportedName)) {
                JSDocInfoBuilder builder = new JSDocInfoBuilder(true);
                builder.recordConstancy();
                JSDocInfo info = builder.build();
                assign.setJSDocInfo(info);
            }
            script.addChildToBack(exprResult);
        }
        NodeTraversal.traverseEs6(this.compiler, script, new RenameGlobalVars(moduleName));
        if (!this.exportMap.isEmpty()) {
            Node googProvide = IR.exprResult(IR.call(NodeUtil.newQName(this.compiler, "goog.provide"), IR.string(moduleName)));
            script.addChildToFront(googProvide.copyInformationFromForTree(script));
            if (this.reportDependencies) {
                t.getInput().addProvide(moduleName);
            }
        }
        JSDocInfoBuilder jSDocInfoBuilder = jsDocInfo = script.getJSDocInfo() == null ? new JSDocInfoBuilder(false) : JSDocInfoBuilder.copyFrom(script.getJSDocInfo());
        if (!jsDocInfo.isPopulatedWithFileOverview()) {
            jsDocInfo.recordFileOverview("");
        }
        jsDocInfo.recordSuppressions((Set<String>)ImmutableSet.of((Object)"missingProvide", (Object)"missingRequire"));
        script.setJSDocInfo(jsDocInfo.build());
        this.exportMap.clear();
        this.compiler.reportCodeChange();
    }

    private static void checkStrictModeDirective(NodeTraversal t, Node n) {
        Preconditions.checkState((boolean)n.isScript(), (Object)n);
        Set<String> directives = n.getDirectives();
        if (directives != null && directives.contains("use strict")) {
            t.report(n, USELESS_USE_STRICT_DIRECTIVE, new String[0]);
        } else if (directives == null) {
            n.setDirectives((Set<String>)USE_STRICT_ONLY);
        } else {
            ImmutableSet.Builder builder = new ImmutableSet.Builder().add((Object)"use strict");
            builder.addAll(directives);
            n.setDirectives((Set<String>)builder.build());
        }
    }

    private void rewriteRequires(Node script) {
        NodeTraversal.traverseEs6(this.compiler, script, new NodeTraversal.AbstractShallowCallback(){

            @Override
            public void visit(NodeTraversal t, Node n, Node parent) {
                if (n.isCall() && n.getFirstChild().matchesQualifiedName("goog.require") && NodeUtil.isNameDeclaration(parent.getParent())) {
                    this.visitRequire(n, parent);
                }
            }

            private void visitRequire(Node requireCall, Node parent) {
                String namespace = requireCall.getLastChild().getString();
                if (!parent.getParent().isConst()) {
                    ProcessEs6Modules.this.compiler.report(JSError.make(parent.getParent(), LHS_OF_GOOG_REQUIRE_MUST_BE_CONST, new String[0]));
                }
                if (parent.isObjectPattern()) {
                    for (Node key = parent.getFirstChild(); key != null; key = key.getNext()) {
                        if (key.hasChildren()) continue;
                        key.addChildToBack(IR.name(key.getString()).useSourceInfoFrom(key));
                    }
                }
                Node replacement = NodeUtil.newQName(ProcessEs6Modules.this.compiler, namespace).srcrefTree(requireCall);
                parent.replaceChild(requireCall, replacement);
                Node varNode = parent.getParent();
                varNode.getParent().addChildBefore(IR.exprResult(requireCall).srcrefTree(requireCall), varNode);
            }
        });
    }

    private static class ModuleOriginalNamePair {
        private String module;
        private String originalName;

        private ModuleOriginalNamePair(String module, String originalName) {
            this.module = module;
            this.originalName = originalName;
        }

        public String toString() {
            return "(" + this.module + ", " + this.originalName + ")";
        }
    }

    private static class NameNodePair {
        final String name;
        final Node nodeForSourceInfo;

        private NameNodePair(String name, Node nodeForSourceInfo) {
            this.name = name;
            this.nodeForSourceInfo = nodeForSourceInfo;
        }

        public String toString() {
            return "(" + this.name + ", " + this.nodeForSourceInfo + ")";
        }
    }

    private class RenameGlobalVars
    extends NodeTraversal.AbstractPostOrderCallback {
        private final String suffix;

        RenameGlobalVars(String suffix) {
            this.suffix = suffix;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            boolean isShorthandObjLitKey;
            JSDocInfo info = n.getJSDocInfo();
            if (info != null) {
                for (Node typeNode : info.getTypeNodes()) {
                    this.fixTypeNode(t, typeNode);
                }
            }
            boolean bl = isShorthandObjLitKey = n.isStringKey() && !n.hasChildren();
            if (n.isName() || isShorthandObjLitKey) {
                String name = n.getString();
                if (this.suffix.equals(name)) {
                    return;
                }
                Var var = t.getScope().getVar(name);
                if (var != null && var.isGlobal()) {
                    String newName = name + "$$" + this.suffix;
                    if (isShorthandObjLitKey) {
                        n.addChildToBack(IR.name(newName).useSourceInfoIfMissingFrom(n));
                    } else {
                        n.setString(newName);
                        n.setOriginalName(name);
                    }
                } else if (var == null && ProcessEs6Modules.this.importMap.containsKey(name)) {
                    if (parent.isCall() && parent.getFirstChild() == n) {
                        parent.putBooleanProp(50, false);
                    }
                    ModuleOriginalNamePair pair = (ModuleOriginalNamePair)ProcessEs6Modules.this.importMap.get(name);
                    Node moduleAccess = NodeUtil.newQName(ProcessEs6Modules.this.compiler, pair.module);
                    if (pair.originalName.isEmpty()) {
                        n.getParent().replaceChild(n, moduleAccess.useSourceInfoIfMissingFromForTree(n));
                    } else {
                        n.getParent().replaceChild(n, IR.getprop(moduleAccess, IR.string(pair.originalName)).useSourceInfoIfMissingFromForTree(n));
                    }
                }
            }
        }

        private void fixTypeNode(NodeTraversal t, Node typeNode) {
            if (typeNode.isString()) {
                String name = typeNode.getString();
                if (ES6ModuleLoader.isRelativeIdentifier(name)) {
                    int lastSlash = name.lastIndexOf(47);
                    int endIndex = name.indexOf(46, lastSlash);
                    String localTypeName = null;
                    if (endIndex == -1) {
                        endIndex = name.length();
                    } else {
                        localTypeName = name.substring(endIndex);
                    }
                    String moduleName = name.substring(0, endIndex);
                    URI loadAddress = ProcessEs6Modules.this.loader.locateEs6Module(moduleName, t.getInput());
                    if (loadAddress == null) {
                        ProcessEs6Modules.this.compiler.report(t.makeError(typeNode, ES6ModuleLoader.LOAD_ERROR, moduleName));
                        return;
                    }
                    String globalModuleName = ES6ModuleLoader.toModuleName(loadAddress);
                    typeNode.setString(localTypeName == null ? globalModuleName : globalModuleName + localTypeName);
                } else {
                    Var var;
                    List splitted = Splitter.on((char)'.').limit(2).splitToList((CharSequence)name);
                    String baseName = (String)splitted.get(0);
                    String rest = "";
                    if (splitted.size() == 2) {
                        rest = "." + (String)splitted.get(1);
                    }
                    if ((var = t.getScope().getVar(baseName)) != null && var.isGlobal()) {
                        typeNode.setString(baseName + "$$" + this.suffix + rest);
                    } else if (var == null && ProcessEs6Modules.this.importMap.containsKey(baseName)) {
                        ModuleOriginalNamePair pair = (ModuleOriginalNamePair)ProcessEs6Modules.this.importMap.get(baseName);
                        if (pair.originalName.isEmpty()) {
                            typeNode.setString(pair.module + rest);
                        } else {
                            typeNode.setString(baseName + "$$" + pair.module + rest);
                        }
                    }
                    typeNode.setOriginalName(name);
                }
            }
            for (Node child = typeNode.getFirstChild(); child != null; child = child.getNext()) {
                this.fixTypeNode(t, child);
            }
            ProcessEs6Modules.this.compiler.reportCodeChange();
        }
    }
}

