/*
 * Copyright (c) 2007, 2009-2012, 2014 Eike Stepper (Loehne, Germany) and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *    Eike Stepper - initial API and implementation
 */
package org.eclipse.emf.cdo.eresource.validation;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource.Diagnostic;
import org.eclipse.emf.ecore.resource.ResourceSet;

/**
 * A sample validator interface for {@link org.eclipse.emf.cdo.eresource.CDOResource}. This doesn't really do anything,
 * and it's not a real EMF artifact. It was generated by the org.eclipse.emf.examples.generator.validator plug-in to
 * illustrate how EMF's code generator can be extended. This can be disabled with -vmargs
 * -Dorg.eclipse.emf.examples.generator.validator=false.
 *
 * @since 2.0
 */
@Deprecated
public interface CDOResourceValidator
{
  @Deprecated
  boolean validate();

  @Deprecated
  boolean validateResourceSet(ResourceSet value);

  @Deprecated
  boolean validateURI(URI value);

  @Deprecated
  boolean validateContents(EList<EObject> value);

  @Deprecated
  boolean validateModified(boolean value);

  @Deprecated
  boolean validateLoaded(boolean value);

  @Deprecated
  boolean validateTrackingModification(boolean value);

  @Deprecated
  boolean validateErrors(EList<Diagnostic> value);

  @Deprecated
  boolean validateWarnings(EList<Diagnostic> value);

  @Deprecated
  boolean validateTimeStamp(long value);
}
