/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui;

import java.net.URI;
import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.provisional.p2.repository.RepositoryEvent;
import org.eclipse.equinox.p2.operations.RepositoryTracker;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class MultipleLocationsNotFoundDialog
implements Runnable {
    private final RepositoryTracker repositoryTracker;
    private final ProvisioningUI ui;
    private final URI[] locations;

    public MultipleLocationsNotFoundDialog(RepositoryTracker repositoryTracker, ProvisioningUI ui, URI[] locations) {
        this.repositoryTracker = repositoryTracker;
        this.ui = ui;
        this.locations = locations;
    }

    @Override
    public void run() {
        boolean removeRepositories;
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench.isClosing()) {
            return;
        }
        Shell shell = ProvUI.getDefaultParentShell();
        int result = MessageDialog.open((int)3, (Shell)shell, (String)ProvUIMessages.ColocatedRepositoryTracker_MultipleSitesNotFoundTitle, (String)ProvUIMessages.ColocatedRepositoryTracker_PromptForMultipleSites, (int)0, (String[])new String[]{ProvUIMessages.ColocatedRepositoryTracker_MultipleSitesNotFound_RemoveButtonLabel, IDialogConstants.NO_LABEL, ProvUIMessages.ColocatedRepositoryTracker_MultipleSitesNotFound_DisableButtonLabel});
        boolean disableRepositories = result == 2;
        boolean bl = removeRepositories = result == 0;
        if (disableRepositories) {
            this.disableRepositories();
        } else if (removeRepositories) {
            this.removeRepositories();
        }
    }

    public void removeRepositories() {
        this.repositoryTracker.removeRepositories(this.locations, this.ui.getSession());
    }

    public void disableRepositories() {
        URI[] uRIArray = this.locations;
        int n = this.locations.length;
        int n2 = 0;
        while (n2 < n) {
            URI location = uRIArray[n2];
            this.disableRepository(location);
            ++n2;
        }
    }

    private void disableRepository(URI location) {
        this.ui.signalRepositoryOperationStart();
        try {
            this.getArtifactRepositoryManager().setEnabled(location, false);
        }
        finally {
            RepositoryEvent artifactRepositoryDisabled = new RepositoryEvent(location, 1, 8, false);
            this.ui.signalRepositoryOperationComplete(artifactRepositoryDisabled, true);
        }
        this.ui.signalRepositoryOperationStart();
        try {
            this.getMetadataRepositoryManager().setEnabled(location, false);
        }
        finally {
            RepositoryEvent metadataRepositoryDisabled = new RepositoryEvent(location, 0, 8, false);
            this.ui.signalRepositoryOperationComplete(metadataRepositoryDisabled, true);
        }
    }

    private IMetadataRepositoryManager getMetadataRepositoryManager() {
        return ProvUI.getMetadataRepositoryManager(this.ui.getSession());
    }

    private IArtifactRepositoryManager getArtifactRepositoryManager() {
        return ProvUI.getArtifactRepositoryManager(this.ui.getSession());
    }
}

