/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import org.eclipse.jgit.internal.storage.file.ObjectDirectory;
import org.eclipse.jgit.internal.storage.file.Pack;
import org.eclipse.jgit.internal.storage.file.PackFile;
import org.eclipse.jgit.internal.storage.midx.MultiPackIndexPrettyPrinter;
import org.eclipse.jgit.internal.storage.midx.MultiPackIndexWriter;
import org.eclipse.jgit.internal.storage.midx.PackIndexMerger;
import org.eclipse.jgit.internal.storage.pack.PackExt;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.pgm.Command;
import org.eclipse.jgit.pgm.TextBuiltin;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

@Command(common=true, usage="usage_MultiPackIndex")
class MultiPackIndex
extends TextBuiltin {
    @Argument(index=0, required=true, usage="write, print")
    private String command;
    @Option(name="--midx")
    private String midxPath;

    MultiPackIndex() {
    }

    @Override
    protected void run() throws IOException {
        switch (this.command) {
            case "print": {
                this.printMultiPackIndex();
                break;
            }
            case "write": {
                this.writeMultiPackIndex();
                break;
            }
            default: {
                this.outw.println("Unknown command " + this.command);
            }
        }
    }

    private void printMultiPackIndex() {
        if (this.midxPath == null || this.midxPath.isEmpty()) {
            throw MultiPackIndex.die("'print' requires the path of a multipack index file with --midx option.");
        }
        try {
            Throwable throwable = null;
            Object var2_5 = null;
            try (FileInputStream is = new FileInputStream(this.midxPath);){
                PrintWriter pw = new PrintWriter((Writer)this.outw, true);
                MultiPackIndexPrettyPrinter.prettyPrint((byte[])is.readAllBytes(), (PrintWriter)pw);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            throw MultiPackIndex.die(true, (Throwable)e);
        }
        catch (IOException e) {
            throw MultiPackIndex.die(true, (Throwable)e);
        }
    }

    private void writeMultiPackIndex() throws IOException {
        if (!(this.db.getObjectDatabase() instanceof ObjectDirectory)) {
            throw MultiPackIndex.die("This repository object db doesn't have packs");
        }
        File midx = this.midxPath == null || this.midxPath.isEmpty() ? new File(((ObjectDirectory)this.db.getObjectDatabase()).getPackDirectory(), "multi-pack-index") : new File(this.midxPath);
        this.errw.println("Writing " + midx.getAbsolutePath());
        ObjectDirectory odb = (ObjectDirectory)this.db.getObjectDatabase();
        PackIndexMerger.Builder builder = PackIndexMerger.builder();
        for (Pack pack : odb.getPacks()) {
            PackFile packFile = pack.getPackFile().create(PackExt.INDEX);
            try {
                builder.addPack(packFile.getName(), pack.getIndex());
            }
            catch (IOException e) {
                throw MultiPackIndex.die("Cannot open index in pack", (Throwable)e);
            }
        }
        MultiPackIndexWriter writer = new MultiPackIndexWriter();
        try {
            Object object = null;
            Object var6_8 = null;
            try (FileOutputStream out = new FileOutputStream(this.midxPath);){
                writer.write((ProgressMonitor)NullProgressMonitor.INSTANCE, (OutputStream)out, builder.build());
            }
            catch (Throwable throwable) {
                if (object == null) {
                    object = throwable;
                } else if (object != throwable) {
                    ((Throwable)object).addSuppressed(throwable);
                }
                throw object;
            }
        }
        catch (IOException e) {
            throw MultiPackIndex.die("Cannot write midx " + this.midxPath, (Throwable)e);
        }
    }
}

