/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.midx;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.MutableObjectId;
import org.eclipse.jgit.lib.ObjectId;

public interface MultiPackIndex
extends Iterable<MutableEntry> {
    public String[] getPackNames();

    public boolean hasObject(AnyObjectId var1);

    public PackOffset find(AnyObjectId var1);

    public int findPosition(AnyObjectId var1);

    public int findBitmapPosition(PackOffset var1);

    public ObjectId getObjectAtBitmapPosition(int var1);

    public ObjectId getObjectAt(int var1);

    public int getObjectCount();

    public void resolve(Set<ObjectId> var1, AbbreviatedObjectId var2, int var3);

    public byte[] getChecksum();

    public long getMemorySize();

    public MidxIterator iterator();

    public static interface MidxIterator
    extends Iterator<MutableEntry> {
        public MutableEntry peek();

        public List<String> getPackNames();

        public void reset();
    }

    public static class MutableEntry {
        protected final MutableObjectId oid = new MutableObjectId();
        protected final PackOffset packOffset = new PackOffset();

        public MutableEntry fill(MutableEntry other, int shift) {
            this.oid.fromObjectId(other.oid);
            this.packOffset.setValues(other.getPackId() + shift, other.getOffset());
            return this;
        }

        public MutableObjectId getObjectId() {
            return this.oid;
        }

        public int getPackId() {
            return this.packOffset.getPackId();
        }

        public long getOffset() {
            return this.packOffset.getOffset();
        }

        public void clear() {
            this.oid.clear();
            this.packOffset.setValues(0, 0L);
        }

        public String toString() {
            return String.format("%s,%s", this.oid.name(), this.packOffset);
        }
    }

    public static class PackOffset
    implements Comparable<PackOffset> {
        private int packId;
        private long offset;

        public static PackOffset create(int packId, long offset) {
            return new PackOffset().setValues(packId, offset);
        }

        public PackOffset setValues(int packId, long offset) {
            this.packId = packId;
            this.offset = offset;
            return this;
        }

        public int getPackId() {
            return this.packId;
        }

        public long getOffset() {
            return this.offset;
        }

        public PackOffset copy() {
            PackOffset copy = new PackOffset();
            return copy.setValues(this.packId, this.offset);
        }

        @Override
        public int compareTo(PackOffset packOffset) {
            int cmp = this.packId - packOffset.packId;
            if (cmp != 0) {
                return cmp;
            }
            return Long.compare(this.offset, packOffset.offset);
        }

        public String toString() {
            return String.format("PackOffset(packId=%d|offset=%d)", this.packId, this.offset);
        }
    }
}

