/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.closure;

import org.eclipse.jpt.common.utility.closure.InterruptibleClosure;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.predicate.Predicate;

public class WhileInterruptibleClosure<A>
implements InterruptibleClosure<A> {
    private final Predicate<? super A> predicate;
    private final InterruptibleClosure<? super A> closure;

    public WhileInterruptibleClosure(Predicate<? super A> predicate, InterruptibleClosure<? super A> closure) {
        if (predicate == null || closure == null) {
            throw new NullPointerException();
        }
        this.predicate = predicate;
        this.closure = closure;
    }

    @Override
    public void execute(A argument) throws InterruptedException {
        while (this.predicate.evaluate(argument)) {
            this.closure.execute(argument);
        }
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.predicate);
    }
}

