/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.common.core.internal.utility.jdt.ASTTools;
import org.eclipse.jpt.common.core.internal.utility.jdt.AnnotatedElementAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ElementAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ElementIndexedAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleTypeStringExpressionConverter;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceModel;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.ExpressionConverter;
import org.eclipse.jpt.common.core.utility.jdt.IndexedAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.IndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.jaxb.core.resource.java.XmlElementRefAnnotation;

public final class SourceXmlElementRefAnnotation
extends SourceAnnotation
implements XmlElementRefAnnotation {
    public static final SimpleDeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.xml.bind.annotation.XmlElementRef");
    private String fullyQualifiedTypeName;
    private final DeclarationAnnotationElementAdapter<String> nameDeclarationAdapter = this.buildNameDeclarationAdapter();
    private final AnnotationElementAdapter<String> nameAdapter = this.buildAnnotationElementAdapter(this.nameDeclarationAdapter);
    private String name;
    private TextRange nameTextRange;
    private TextRange nameValidationTextRange;
    private final DeclarationAnnotationElementAdapter<String> namespaceDeclarationAdapter = this.buildNamespaceDeclarationAdapter();
    private final AnnotationElementAdapter<String> namespaceAdapter = this.buildAnnotationElementAdapter(this.namespaceDeclarationAdapter);
    private String namespace;
    private TextRange namespaceTextRange;
    private TextRange namespaceValidationTextRange;
    private final DeclarationAnnotationElementAdapter<Boolean> requiredDeclarationAdapter;
    private final AnnotationElementAdapter<Boolean> requiredAdapter;
    private Boolean required;
    private TextRange requiredTextRange;
    private final DeclarationAnnotationElementAdapter<String> typeDeclarationAdapter;
    private final AnnotationElementAdapter<String> typeAdapter;
    private String type;
    private TextRange typeTextRange;

    public static SourceXmlElementRefAnnotation buildSourceXmlElementRefAnnotation(JavaResourceAnnotatedElement parent, AnnotatedElement annotatedElement) {
        return new SourceXmlElementRefAnnotation((JavaResourceModel)parent, annotatedElement, (DeclarationAnnotationAdapter)DECLARATION_ANNOTATION_ADAPTER);
    }

    public static SourceXmlElementRefAnnotation buildNestedSourceXmlElementRefAnnotation(JavaResourceModel parent, AnnotatedElement annotatedElement, IndexedDeclarationAnnotationAdapter idaa) {
        return new SourceXmlElementRefAnnotation(parent, annotatedElement, idaa);
    }

    private SourceXmlElementRefAnnotation(JavaResourceModel parent, AnnotatedElement annotatedElement, DeclarationAnnotationAdapter daa) {
        this(parent, annotatedElement, daa, (AnnotationAdapter)new ElementAnnotationAdapter(annotatedElement, daa));
    }

    private SourceXmlElementRefAnnotation(JavaResourceModel parent, AnnotatedElement annotatedElement, IndexedDeclarationAnnotationAdapter idaa) {
        this(parent, annotatedElement, (DeclarationAnnotationAdapter)idaa, (AnnotationAdapter)new ElementIndexedAnnotationAdapter(annotatedElement, idaa));
    }

    private SourceXmlElementRefAnnotation(JavaResourceModel parent, AnnotatedElement annotatedElement, DeclarationAnnotationAdapter daa, AnnotationAdapter annotationAdapter) {
        super(parent, annotatedElement, daa, annotationAdapter);
        this.requiredDeclarationAdapter = this.buildRequiredAdapter(daa);
        this.requiredAdapter = this.buildShortCircuitBooleanElementAdapter(this.requiredDeclarationAdapter);
        this.typeDeclarationAdapter = this.buildTypeDeclarationAdapter();
        this.typeAdapter = this.buildAnnotationElementAdapter(this.typeDeclarationAdapter);
    }

    private DeclarationAnnotationElementAdapter<String> buildNameDeclarationAdapter() {
        return ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)this.daa, (String)"name");
    }

    private DeclarationAnnotationElementAdapter<String> buildNamespaceDeclarationAdapter() {
        return ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)this.daa, (String)"namespace");
    }

    private DeclarationAnnotationElementAdapter<Boolean> buildRequiredAdapter(DeclarationAnnotationAdapter daa) {
        return ConversionDeclarationAnnotationElementAdapter.forBooleans((DeclarationAnnotationAdapter)daa, (String)"required");
    }

    private DeclarationAnnotationElementAdapter<String> buildTypeDeclarationAdapter() {
        return SourceXmlElementRefAnnotation.buildAnnotationElementAdapter(this.daa, "type", (ExpressionConverter<String>)SimpleTypeStringExpressionConverter.instance());
    }

    private static DeclarationAnnotationElementAdapter<String> buildAnnotationElementAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName, ExpressionConverter<String> converter) {
        return new ConversionDeclarationAnnotationElementAdapter(annotationAdapter, elementName, converter);
    }

    private AnnotationElementAdapter<String> buildAnnotationElementAdapter(DeclarationAnnotationElementAdapter<String> daea) {
        return new AnnotatedElementAnnotationElementAdapter(this.annotatedElement, daea);
    }

    private AnnotationElementAdapter<Boolean> buildShortCircuitBooleanElementAdapter(DeclarationAnnotationElementAdapter<Boolean> daea) {
        return new AnnotatedElementAnnotationElementAdapter(this.annotatedElement, daea);
    }

    public String getAnnotationName() {
        return "javax.xml.bind.annotation.XmlElementRef";
    }

    public void initialize(Annotation astAnnotation) {
        super.initialize(astAnnotation);
        this.name = this.buildName(astAnnotation);
        this.nameTextRange = this.buildNameTextRange(astAnnotation);
        this.nameValidationTextRange = this.buildNameValidationTextRange(astAnnotation);
        this.namespace = this.buildNamespace(astAnnotation);
        this.namespaceTextRange = this.buildNamespaceTextRange(astAnnotation);
        this.namespaceValidationTextRange = this.buildNamespaceValidationTextRange(astAnnotation);
        this.required = this.buildRequired(astAnnotation);
        this.requiredTextRange = this.buildRequiredTextRange(astAnnotation);
        this.type = this.buildType(astAnnotation);
        this.fullyQualifiedTypeName = this.buildFullyQualifiedTypeName(astAnnotation);
        this.typeTextRange = this.buildTypeTextRange(astAnnotation);
    }

    public void synchronizeWith(Annotation astAnnotation) {
        super.synchronizeWith(astAnnotation);
        this.syncName(this.buildName(astAnnotation));
        this.nameTextRange = this.buildNameTextRange(astAnnotation);
        this.nameValidationTextRange = this.buildNameValidationTextRange(astAnnotation);
        this.syncNamespace(this.buildNamespace(astAnnotation));
        this.namespaceTextRange = this.buildNamespaceTextRange(astAnnotation);
        this.namespaceValidationTextRange = this.buildNamespaceValidationTextRange(astAnnotation);
        this.syncRequired(this.buildRequired(astAnnotation));
        this.requiredTextRange = this.buildRequiredTextRange(astAnnotation);
        this.syncType(this.buildType(astAnnotation));
        this.syncFullyQualifiedTypeName(this.buildFullyQualifiedTypeName(astAnnotation));
        this.typeTextRange = this.buildTypeTextRange(astAnnotation);
    }

    public void toString(StringBuilder sb) {
        sb.append(this.name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        if (ObjectTools.notEquals((Object)this.name, (Object)name)) {
            this.name = name;
            this.nameAdapter.setValue((Object)name);
        }
    }

    private void syncName(String astName) {
        String old = this.name;
        this.name = astName;
        this.firePropertyChanged("name", old, astName);
    }

    private String buildName(Annotation astAnnotation) {
        return (String)this.nameAdapter.getValue(astAnnotation);
    }

    private TextRange buildNameTextRange(Annotation astAnnotation) {
        return this.getAnnotationElementTextRange(this.nameDeclarationAdapter, astAnnotation);
    }

    private TextRange buildNameValidationTextRange(Annotation astAnnotation) {
        return this.getElementTextRange(this.nameDeclarationAdapter, astAnnotation);
    }

    @Override
    public TextRange getNameTextRange() {
        return this.nameTextRange;
    }

    @Override
    public TextRange getNameValidationTextRange() {
        return this.nameValidationTextRange;
    }

    @Override
    public boolean nameTouches(int pos) {
        return this.textRangeTouches(this.nameTextRange, pos);
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public void setNamespace(String namespace) {
        if (ObjectTools.notEquals((Object)this.namespace, (Object)namespace)) {
            this.namespace = namespace;
            this.namespaceAdapter.setValue((Object)namespace);
        }
    }

    private void syncNamespace(String astNamespace) {
        String old = this.namespace;
        this.namespace = astNamespace;
        this.firePropertyChanged("namespace", old, astNamespace);
    }

    private String buildNamespace(Annotation astAnnotation) {
        return (String)this.namespaceAdapter.getValue(astAnnotation);
    }

    private TextRange buildNamespaceTextRange(Annotation astAnnotation) {
        return this.getAnnotationElementTextRange(this.namespaceDeclarationAdapter, astAnnotation);
    }

    private TextRange buildNamespaceValidationTextRange(Annotation astAnnotation) {
        return this.getElementTextRange(this.namespaceDeclarationAdapter, astAnnotation);
    }

    @Override
    public TextRange getNamespaceTextRange() {
        return this.namespaceTextRange;
    }

    @Override
    public TextRange getNamespaceValidationTextRange() {
        return this.namespaceValidationTextRange;
    }

    @Override
    public boolean namespaceTouches(int pos) {
        return this.textRangeTouches(this.namespaceTextRange, pos);
    }

    @Override
    public Boolean getRequired() {
        return this.required;
    }

    @Override
    public void setRequired(Boolean required) {
        if (ObjectTools.notEquals((Object)this.required, (Object)required)) {
            this.required = required;
            this.requiredAdapter.setValue((Object)required);
        }
    }

    private void syncRequired(Boolean astRequired) {
        Boolean old = this.required;
        this.required = astRequired;
        this.firePropertyChanged("required", old, astRequired);
    }

    private Boolean buildRequired(Annotation astAnnotation) {
        return (Boolean)this.requiredAdapter.getValue(astAnnotation);
    }

    private TextRange buildRequiredTextRange(Annotation astAnnotation) {
        return this.getElementTextRange(this.requiredDeclarationAdapter, astAnnotation);
    }

    @Override
    public TextRange getRequiredTextRange() {
        return this.requiredTextRange;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        if (ObjectTools.notEquals((Object)this.type, (Object)type)) {
            this.type = type;
            this.typeAdapter.setValue((Object)type);
        }
    }

    private void syncType(String astType) {
        String old = this.type;
        this.type = astType;
        this.firePropertyChanged("type", old, astType);
    }

    private String buildType(Annotation astAnnotation) {
        return (String)this.typeAdapter.getValue(astAnnotation);
    }

    private TextRange buildTypeTextRange(Annotation astAnnotation) {
        return this.getElementTextRange(this.typeDeclarationAdapter, astAnnotation);
    }

    @Override
    public TextRange getTypeTextRange() {
        return this.typeTextRange;
    }

    @Override
    public String getFullyQualifiedTypeName() {
        return this.fullyQualifiedTypeName;
    }

    private void syncFullyQualifiedTypeName(String name) {
        String old = this.fullyQualifiedTypeName;
        this.fullyQualifiedTypeName = name;
        this.firePropertyChanged("fullyQualifiedTypeName", old, name);
    }

    private String buildFullyQualifiedTypeName(Annotation astAnnotation) {
        return this.type == null ? null : ASTTools.resolveFullyQualifiedName((Expression)this.typeAdapter.getExpression(astAnnotation));
    }

    public void moveAnnotation(int newIndex) {
        this.getIndexedAnnotationAdapter().moveAnnotation(newIndex);
    }

    private IndexedAnnotationAdapter getIndexedAnnotationAdapter() {
        return (IndexedAnnotationAdapter)this.annotationAdapter;
    }
}

