/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp.internal.conversion;

import org.apache.maven.model.Build;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jst.j2ee.project.facet.IJ2EEFacetConstants;
import org.eclipse.m2e.wtp.WTPProjectsUtil;
import org.eclipse.m2e.wtp.internal.conversion.AbstractWtpProjectConversionParticipant;
import org.eclipse.m2e.wtp.internal.conversion.MavenPluginUtils;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class EjbProjectConverter
extends AbstractWtpProjectConversionParticipant {
    private static final String EJB_VERSION = "ejbVersion";

    public void convert(IProject project, Model model, IProgressMonitor monitor) throws CoreException {
        if (!this.accept(project) || !"ejb".equals(model.getPackaging())) {
            return;
        }
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        if (component == null) {
            return;
        }
        this.setEjbPlugin(component, model);
    }

    private void setEjbPlugin(IVirtualComponent component, Model model) throws CoreException {
        IProjectFacetVersion ejbVersion;
        Build build = this.getCloneOrCreateBuild(model);
        String pluginVersion = this.getEjbPluginVersion();
        Plugin ejbPlugin = this.setPlugin(build, "org.apache.maven.plugins", "maven-ejb-plugin", pluginVersion);
        IFacetedProject fProject = ProjectFacetsManager.create((IProject)component.getProject());
        boolean customized = false;
        if (fProject != null && !IJ2EEFacetConstants.EJB_21.equals(ejbVersion = fProject.getProjectFacetVersion(IJ2EEFacetConstants.EJB_FACET))) {
            MavenPluginUtils.configure(ejbPlugin, EJB_VERSION, ejbVersion.getVersionString());
            customized = true;
        }
        if (customized) {
            model.setBuild(build);
        }
    }

    @Override
    protected IProjectFacet getRequiredFaced() {
        return WTPProjectsUtil.EJB_FACET;
    }

    private String getEjbPluginVersion() {
        String version = System.getProperty("org.eclipse.m2e.wtp.conversion.ejbplugin.version");
        if (version != null) {
            return version;
        }
        return MavenPluginUtils.getMostRecentPluginVersion("org.apache.maven.plugins", "maven-ejb-plugin", "3.0.1");
    }
}

