/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp.internal.filtering;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.wtp.AbstractFilteringSupportMavenPlugin;
import org.eclipse.m2e.wtp.internal.filtering.ResourceFilteringConfiguration;

public abstract class AbstractResourceFilteringConfiguration
implements ResourceFilteringConfiguration {
    protected IMavenProjectFacade mavenProjectFacade;
    protected AbstractFilteringSupportMavenPlugin pluginConfiguration;

    public AbstractResourceFilteringConfiguration(IMavenProjectFacade mavenProjectFacade) {
        this.mavenProjectFacade = mavenProjectFacade;
    }

    @Override
    public List<String> getFilters() {
        ArrayList<String> filters = new ArrayList<String>(this.mavenProjectFacade.getMavenProject().getFilters());
        if (this.pluginConfiguration != null) {
            filters.addAll(this.pluginConfiguration.getFilters());
        }
        return filters;
    }

    @Override
    public String getEscapeString() {
        if (this.pluginConfiguration == null) {
            return null;
        }
        return this.pluginConfiguration.getEscapeString();
    }

    @Override
    public List<Xpp3Dom> getNonfilteredExtensions() {
        if (this.pluginConfiguration == null) {
            return Collections.emptyList();
        }
        Xpp3Dom[] domext = this.pluginConfiguration.getNonfilteredExtensions();
        if (domext == null || domext.length == 0) {
            return Collections.emptyList();
        }
        return Arrays.asList(domext);
    }
}

