/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.common.core.strings;

import java.util.Vector;

public class StringMatcher {
    private final String fPattern;
    private final int fLength;
    private final boolean fIgnoreWildCards;
    private final boolean fIgnoreCase;
    private boolean fHasLeadingStar;
    private boolean fHasTrailingStar;
    private String[] fSegments;
    private int fBound = 0;
    private static final char SINGLE_WILD_CARD = '\u0000';

    public StringMatcher(String pattern, boolean ignoreCase, boolean ignoreWildCards) {
        if (pattern == null) {
            throw new IllegalArgumentException();
        }
        this.fIgnoreCase = ignoreCase;
        this.fIgnoreWildCards = ignoreWildCards;
        this.fPattern = pattern;
        this.fLength = pattern.length();
        if (this.fIgnoreWildCards) {
            this.parseNoWildCards();
        } else {
            this.parseWildCards();
        }
    }

    public Position find(String text, int start, int end) {
        int newStart = start;
        int newEnd = end;
        if (text == null) {
            throw new IllegalArgumentException();
        }
        int tlen = text.length();
        if (newStart < 0) {
            newStart = 0;
        }
        if (newEnd > tlen) {
            newEnd = tlen;
        }
        if (newEnd < 0 || newStart >= newEnd) {
            return null;
        }
        if (this.fLength == 0) {
            return new Position(newStart, newStart);
        }
        if (this.fIgnoreWildCards) {
            int x = this.posIn(text, newStart, newEnd);
            if (x < 0) {
                return null;
            }
            return new Position(x, x + this.fLength);
        }
        int segCount = this.fSegments.length;
        if (segCount == 0) {
            return new Position(newStart, newEnd);
        }
        int curPos = newStart;
        int matchStart = -1;
        int i = 0;
        while (i < segCount && curPos < newEnd) {
            String current = this.fSegments[i];
            int nextMatch = this.regExpPosIn(text, curPos, newEnd, current);
            if (nextMatch < 0) {
                return null;
            }
            if (i == 0) {
                matchStart = nextMatch;
            }
            curPos = nextMatch + current.length();
            ++i;
        }
        if (i < segCount) {
            return null;
        }
        return new Position(matchStart, curPos);
    }

    public boolean match(String text) {
        return this.match(text, 0, text.length());
    }

    /*
     * Unable to fully structure code
     */
    public boolean match(String text, int start, int end) {
        newStart = start;
        newEnd = end;
        if (text == null) {
            throw new IllegalArgumentException();
        }
        if (newStart > newEnd) {
            return false;
        }
        if (this.fIgnoreWildCards) {
            return newEnd - newStart == this.fLength && this.fPattern.regionMatches(this.fIgnoreCase, 0, text, newStart, this.fLength) != false;
        }
        segCount = this.fSegments.length;
        if (segCount == 0 && (this.fHasLeadingStar || this.fHasTrailingStar)) {
            return true;
        }
        if (newStart == newEnd) {
            return this.fLength == 0;
        }
        if (this.fLength == 0) {
            return newStart == newEnd;
        }
        tlen = text.length();
        if (newStart < 0) {
            newStart = 0;
        }
        if (newEnd > tlen) {
            newEnd = tlen;
        }
        tCurPos = newStart;
        bound = newEnd - this.fBound;
        if (bound < 0) {
            return false;
        }
        i = 0;
        current = this.fSegments[i];
        segLength = current.length();
        if (!this.fHasLeadingStar) {
            if (!this.regExpRegionMatches(text, newStart, current, 0, segLength)) {
                return false;
            }
            ++i;
            tCurPos += segLength;
        }
        if (this.fSegments.length != 1 || this.fHasLeadingStar || this.fHasTrailingStar) ** GOTO lbl41
        return tCurPos == newEnd;
lbl-1000:
        // 1 sources

        {
            current = this.fSegments[i];
            k = current.indexOf(0);
            if (k < 0 ? (currentMatch = this.textPosIn(text, tCurPos, newEnd, current)) < 0 : (currentMatch = this.regExpPosIn(text, tCurPos, newEnd, current)) < 0) {
                return false;
            }
            tCurPos = currentMatch + current.length();
            ++i;
lbl41:
            // 2 sources

            ** while (i < segCount && tCurPos <= bound)
        }
lbl42:
        // 1 sources

        if (!this.fHasTrailingStar && tCurPos != newEnd) {
            clen = current.length();
            return this.regExpRegionMatches(text, newEnd - clen, current, 0, clen);
        }
        return i == segCount;
    }

    private void parseNoWildCards() {
        this.fSegments = new String[1];
        this.fSegments[0] = this.fPattern;
        this.fBound = this.fLength;
    }

    private void parseWildCards() {
        if (this.fPattern.startsWith("*")) {
            this.fHasLeadingStar = true;
        }
        if (this.fPattern.endsWith("*") && this.fLength > 1 && this.fPattern.charAt(this.fLength - 2) != '\\') {
            this.fHasTrailingStar = true;
        }
        Vector<String> temp = new Vector<String>();
        int pos = 0;
        StringBuffer buf = new StringBuffer();
        block5: while (pos < this.fLength) {
            char c = this.fPattern.charAt(pos++);
            switch (c) {
                case '\\': {
                    char next;
                    if (pos >= this.fLength) {
                        buf.append(c);
                        break;
                    }
                    if ((next = this.fPattern.charAt(pos++)) == '*' || next == '?' || next == '\\') {
                        buf.append(next);
                        break;
                    }
                    buf.append(c);
                    buf.append(next);
                    break;
                }
                case '*': {
                    if (buf.length() <= 0) continue block5;
                    temp.addElement(buf.toString());
                    this.fBound += buf.length();
                    buf.setLength(0);
                    break;
                }
                case '?': {
                    buf.append('\u0000');
                    break;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        if (buf.length() > 0) {
            temp.addElement(buf.toString());
            this.fBound += buf.length();
        }
        this.fSegments = new String[temp.size()];
        temp.copyInto(this.fSegments);
    }

    protected int posIn(String text, int start, int end) {
        int max = end - this.fLength;
        if (!this.fIgnoreCase) {
            int i = text.indexOf(this.fPattern, start);
            if (i == -1 || i > max) {
                return -1;
            }
            return i;
        }
        int i = start;
        while (i <= max) {
            if (text.regionMatches(true, i, this.fPattern, 0, this.fLength)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected int regExpPosIn(String text, int start, int end, String p) {
        int plen = p.length();
        int max = end - plen;
        int i = start;
        while (i <= max) {
            if (this.regExpRegionMatches(text, i, p, 0, plen)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected boolean regExpRegionMatches(String text, int tStart, String p, int pStart, int plen) {
        int curTStart = tStart;
        int curPStart = pStart;
        int curPlen = plen;
        while (curPlen-- > 0) {
            char tchar = text.charAt(curTStart++);
            char pchar = p.charAt(curPStart++);
            if (!this.fIgnoreWildCards && pchar == '\u0000' || pchar == tchar || this.fIgnoreCase && (Character.toUpperCase(tchar) == Character.toUpperCase(pchar) || Character.toLowerCase(tchar) == Character.toLowerCase(pchar))) continue;
            return false;
        }
        return true;
    }

    protected int textPosIn(String text, int start, int end, String p) {
        int plen = p.length();
        int max = end - plen;
        if (!this.fIgnoreCase) {
            int i = text.indexOf(p, start);
            if (i == -1 || i > max) {
                return -1;
            }
            return i;
        }
        int i = start;
        while (i <= max) {
            if (text.regionMatches(true, i, p, 0, plen)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static class Position {
        private final int start;
        private final int end;

        public Position(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }
    }
}

