/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.facet.efacet.ui.internal.view;

import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.modisco.common.core.Logger;
import org.eclipse.modisco.facet.efacet.ui.internal.Activator;
import org.eclipse.modisco.facet.efacet.ui.internal.exported.view.INavigationView;
import org.eclipse.modisco.facet.efacet.ui.internal.exported.view.INavigationViewFactory;
import org.eclipse.modisco.facet.efacet.ui.internal.sync.generated.SynchronizedNavigationView;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class NavigationViewFactory
implements INavigationViewFactory {
    public static final String VIEW_ID = "org.eclipse.modisco.facet.efacet.ui.view.navigation";

    @Override
    public INavigationView openNavigationView(EditingDomain editingDomain) {
        SynchronizedNavigationView result = null;
        try {
            IWorkbenchPage activePage;
            IWorkbenchWindow window = PlatformUI.getWorkbench().getWorkbenchWindows()[0];
            if (window != null && (activePage = window.getActivePage()) != null) {
                IViewPart view = activePage.showView(VIEW_ID);
                if (view instanceof INavigationView) {
                    result = new SynchronizedNavigationView((INavigationView)view, window.getShell().getDisplay());
                } else {
                    String message = String.format("Something wrong happend when trying to open the EMF Facet navigation view. The view was expected to be of type %s but is of type %s", INavigationView.class.getName(), view.getClass().getName());
                    Logger.logError((String)message, (Plugin)Activator.getDefault());
                }
            }
        }
        catch (PartInitException e) {
            Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
        }
        return result;
    }
}

